/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.NonNull;
import com.vungle.warren.AdLoader;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import java.util.concurrent.ExecutorService;

class DownloadCallbackWrapper
implements AdLoader.DownloadCallback {
    private final AdLoader.DownloadCallback downloadCallback;
    private final ExecutorService executorService;

    public DownloadCallbackWrapper(ExecutorService executorService, AdLoader.DownloadCallback downloadCallback) {
        this.downloadCallback = downloadCallback;
        this.executorService = executorService;
    }

    @Override
    public void onDownloadCompleted(final @NonNull String placementId, final @NonNull String advertisementId) {
        if (this.downloadCallback == null) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                DownloadCallbackWrapper.this.downloadCallback.onDownloadCompleted(placementId, advertisementId);
            }
        });
    }

    @Override
    public void onDownloadFailed(final @NonNull VungleException exception, final String placementId, final String advertisementId) {
        if (this.downloadCallback == null) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                DownloadCallbackWrapper.this.downloadCallback.onDownloadFailed(exception, placementId, advertisementId);
            }
        });
    }

    @Override
    public void onReady(final @NonNull String id, final @NonNull Placement placement, final @NonNull Advertisement advertisement) {
        if (this.downloadCallback == null) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                DownloadCallbackWrapper.this.downloadCallback.onReady(id, placement, advertisement);
            }
        });
    }
}

