/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moat.analytics.mobile.vng.MoatFactory;
import com.moat.analytics.mobile.vng.MoatPlugin;
import com.moat.analytics.mobile.vng.ReactiveVideoTracker;
import com.moat.analytics.mobile.vng.ReactiveVideoTrackerPlugin;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdLoader;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.SessionData;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.analytics.JobDelegateAnalytics;
import com.vungle.warren.analytics.MoatTracker;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.Placement;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.JavascriptBridge;
import com.vungle.warren.ui.OrientationDelegate;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.WebAdContract;
import com.vungle.warren.ui.presenter.LocalAdPresenter;
import com.vungle.warren.ui.presenter.MRAIDAdPresenter;
import com.vungle.warren.ui.state.OptionsState;
import com.vungle.warren.ui.view.FullAdWidget;
import com.vungle.warren.ui.view.LocalAdView;
import com.vungle.warren.ui.view.MRAIDAdView;
import com.vungle.warren.ui.view.VungleWebClient;
import com.vungle.warren.utility.ActivityManager;
import com.vungle.warren.utility.HandlerScheduler;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;

public class AdvertisementPresentationFactory
implements PresentationFactory {
    private static final String TAG = AdvertisementPresentationFactory.class.getSimpleName();
    private static final String EXTRA_ADVERTISEMENT = "ADV_FACTORY_ADVERTISEMENT";
    private final JobRunner jobRunner;
    private VungleApiClient apiClient;
    private BaseTask task;
    private Repository repository;
    private VungleStaticApi vungleStaticApi;
    private Advertisement currentAdvertisement;
    private final AdLoader adLoader;
    private final SessionData sessionData;
    private BaseTask.OnModelLoadListener onModelLoadListener = new BaseTask.OnModelLoadListener(){

        @Override
        public void onLoad(Advertisement ad, Placement pl) {
            AdvertisementPresentationFactory.this.currentAdvertisement = ad;
        }
    };

    AdvertisementPresentationFactory(@NonNull AdLoader adLoader, @NonNull VungleStaticApi vungleStaticApi, @NonNull Repository repository, @NonNull VungleApiClient vungleApiClient, @NonNull JobRunner jobRunner, @NonNull RuntimeValues runtimeValues) {
        this.vungleStaticApi = vungleStaticApi;
        this.repository = repository;
        this.apiClient = vungleApiClient;
        this.jobRunner = jobRunner;
        this.adLoader = adLoader;
        this.sessionData = runtimeValues.sessionData.get();
    }

    @Override
    public void getFullScreenPresentation(@NonNull Context context, @NonNull String placementId, @NonNull FullAdWidget fullAdWidget, @Nullable OptionsState optionsState, @NonNull CloseDelegate closeDelegate, @NonNull OrientationDelegate orientationDelegate, @Nullable Bundle savedState, @NonNull PresentationFactory.FullScreenCallback fullscreenCallback) {
        this.cancelTask();
        this.task = new FullScreenPresentationTask(context, this.adLoader, placementId, this.repository, this.vungleStaticApi, this.jobRunner, this.apiClient, this.sessionData, fullAdWidget, optionsState, orientationDelegate, closeDelegate, fullscreenCallback, this.onModelLoadListener, savedState);
        this.task.execute(new Void[0]);
    }

    private void cancelTask() {
        if (this.task != null) {
            this.task.cancel(true);
            this.task.clear();
        }
    }

    @Override
    public void getNativeViewPresentation(@NonNull String placementId, @Nullable AdConfig adConfig, @NonNull CloseDelegate closeDelegate, @NonNull PresentationFactory.ViewCallback viewCallback) {
        this.cancelTask();
        this.task = new NativeViewPresentationTask(placementId, adConfig, this.adLoader, this.repository, this.vungleStaticApi, this.jobRunner, viewCallback, null, this.sessionData, this.onModelLoadListener);
        this.task.execute(new Void[0]);
    }

    @Override
    public void saveState(Bundle bundle) {
        bundle.putString(EXTRA_ADVERTISEMENT, this.currentAdvertisement == null ? null : this.currentAdvertisement.getId());
    }

    @Override
    public void destroy() {
        this.cancelTask();
    }

    private static abstract class BaseTask
    extends AsyncTask<Void, Void, PresentationResultHolder> {
        protected final Repository repository;
        protected final VungleStaticApi vungleStaticApi;
        private OnModelLoadListener onDataLoadedListener;
        private AtomicReference<Advertisement> adRef = new AtomicReference();
        private AtomicReference<Placement> plRef = new AtomicReference();

        BaseTask(Repository repository, VungleStaticApi vungleStaticApi, OnModelLoadListener onModelLoadListener) {
            this.repository = repository;
            this.vungleStaticApi = vungleStaticApi;
            this.onDataLoadedListener = onModelLoadListener;
        }

        Pair<Advertisement, Placement> loadPresentationData(String placementId, Bundle savedInstanceState) throws VungleException {
            if (!this.vungleStaticApi.isInitialized()) {
                throw new VungleException(9);
            }
            if (TextUtils.isEmpty((CharSequence)placementId)) {
                throw new VungleException(10);
            }
            Placement placement = this.repository.load(placementId, Placement.class).get();
            if (placement == null) {
                Log.e((String)TAG, (String)"No Placement for ID");
                throw new VungleException(13);
            }
            this.plRef.set(placement);
            Advertisement advertisement = null;
            if (savedInstanceState == null) {
                advertisement = this.repository.findValidAdvertisementForPlacement(placementId).get();
            } else {
                String adId = savedInstanceState.getString(AdvertisementPresentationFactory.EXTRA_ADVERTISEMENT);
                if (!TextUtils.isEmpty((CharSequence)adId)) {
                    advertisement = this.repository.load(adId, Advertisement.class).get();
                }
            }
            if (advertisement == null) {
                throw new VungleException(10);
            }
            this.adRef.set(advertisement);
            File assetDir = this.repository.getAdvertisementAssetDirectory(advertisement.getId()).get();
            if (assetDir == null || !assetDir.isDirectory()) {
                Log.e((String)TAG, (String)"Advertisement assets dir is missing");
                throw new VungleException(26);
            }
            return new Pair((Object)advertisement, (Object)placement);
        }

        protected void onPostExecute(PresentationResultHolder presentationResultHolder) {
            super.onPostExecute((Object)presentationResultHolder);
            if (this.onDataLoadedListener != null) {
                this.onDataLoadedListener.onLoad(this.adRef.get(), this.plRef.get());
            }
        }

        void clear() {
            this.onDataLoadedListener = null;
        }

        static interface OnModelLoadListener {
            public void onLoad(Advertisement var1, Placement var2);
        }
    }

    private static class NativeViewPresentationTask
    extends BaseTask {
        private final String placementId;
        private final AdConfig adConfig;
        private final PresentationFactory.ViewCallback viewCallback;
        private final Bundle savedState;
        private final JobRunner jobRunner;
        private final AdLoader adLoader;
        private final SessionData sessionData;

        NativeViewPresentationTask(String placementId, AdConfig adConfig, AdLoader adLoader, Repository repository, VungleStaticApi vungleStaticApi, JobRunner jobRunner, PresentationFactory.ViewCallback viewCallback, Bundle savedState, SessionData sessionData, BaseTask.OnModelLoadListener onModelLoadListener) {
            super(repository, vungleStaticApi, onModelLoadListener);
            this.placementId = placementId;
            this.adConfig = adConfig;
            this.viewCallback = viewCallback;
            this.savedState = savedState;
            this.jobRunner = jobRunner;
            this.adLoader = adLoader;
            this.sessionData = sessionData;
        }

        protected PresentationResultHolder doInBackground(Void ... voids) {
            Pair<Advertisement, Placement> data;
            try {
                data = this.loadPresentationData(this.placementId, this.savedState);
            }
            catch (VungleException e) {
                return new PresentationResultHolder(e);
            }
            Advertisement advertisement = (Advertisement)data.first;
            if (advertisement.getAdType() != 1) {
                return new PresentationResultHolder(new VungleException(10));
            }
            Placement placement = (Placement)data.second;
            if (!this.adLoader.canPlayAd(advertisement)) {
                Log.e((String)TAG, (String)"Advertisement is null or assets are missing");
                if (placement.isAutoCached()) {
                    this.adLoader.loadEndless(placement, 0L);
                }
                return new PresentationResultHolder(new VungleException(10));
            }
            JobDelegateAnalytics adAnalytics = new JobDelegateAnalytics(this.jobRunner);
            VungleWebClient webClient = new VungleWebClient(advertisement, placement);
            File assetDir = this.repository.getAdvertisementAssetDirectory(advertisement.getId()).get();
            if (assetDir == null || !assetDir.isDirectory()) {
                Log.e((String)TAG, (String)"Advertisement assets dir is missing");
                return new PresentationResultHolder(new VungleException(26));
            }
            if (advertisement.getAdType() != 1) {
                Log.e((String)TAG, (String)"Invalid Ad Type for Native Ad.");
                return new PresentationResultHolder(new VungleException(10));
            }
            if ("mrec".equals(advertisement.getTemplateType()) && this.adConfig.getAdSize() != AdConfig.AdSize.VUNGLE_MREC || "flexfeed".equals(advertisement.getTemplateType()) && this.adConfig.getAdSize() != AdConfig.AdSize.VUNGLE_DEFAULT) {
                Log.e((String)TAG, (String)"Corresponding AdConfig#setAdSize must be passed for the type/size of native ad");
                return new PresentationResultHolder(new VungleException(28));
            }
            advertisement.configure(this.adConfig);
            try {
                this.repository.save(advertisement);
            }
            catch (DatabaseHelper.DBException e) {
                return new PresentationResultHolder(new VungleException(26));
            }
            MRAIDAdPresenter presenter = new MRAIDAdPresenter(advertisement, placement, this.repository, new HandlerScheduler(), adAnalytics, webClient, null, assetDir, this.sessionData, ActivityManager.getInstance());
            return new PresentationResultHolder(null, presenter, webClient, null, null);
        }

        @Override
        protected void onPostExecute(PresentationResultHolder result) {
            super.onPostExecute(result);
            if (!this.isCancelled() && this.viewCallback != null) {
                this.viewCallback.onResult((Pair<WebAdContract.WebAdPresenter, VungleWebClient>)new Pair((Object)((WebAdContract.WebAdPresenter)result.advertisementPresenter), (Object)result.webClient), result.exception);
            }
        }
    }

    private static class FullScreenPresentationTask
    extends BaseTask {
        private final AdLoader adLoader;
        @SuppressLint(value={"StaticFieldLeak"})
        private FullAdWidget fullAdWidget;
        @SuppressLint(value={"StaticFieldLeak"})
        private Context context;
        private final String placementId;
        private final OptionsState optionsState;
        private final PresentationFactory.FullScreenCallback fullscreenCallback;
        private final Bundle savedState;
        private final JobRunner jobRunner;
        private final VungleApiClient apiClient;
        private final CloseDelegate closeDelegate;
        private final OrientationDelegate orientationDelegate;
        private final SessionData sessionData;
        private Advertisement advertisement;

        FullScreenPresentationTask(Context context, AdLoader adLoader, String placementId, Repository repository, VungleStaticApi vungleStaticApi, JobRunner jobRunner, VungleApiClient apiClient, SessionData sessionData, FullAdWidget fullAdWidget, OptionsState optionsState, OrientationDelegate orientationDelegate, CloseDelegate closeDelegate, PresentationFactory.FullScreenCallback fullscreenCallback, BaseTask.OnModelLoadListener onModelLoadListener, Bundle savedState) {
            super(repository, vungleStaticApi, onModelLoadListener);
            this.placementId = placementId;
            this.fullAdWidget = fullAdWidget;
            this.optionsState = optionsState;
            this.context = context;
            this.fullscreenCallback = fullscreenCallback;
            this.savedState = savedState;
            this.jobRunner = jobRunner;
            this.apiClient = apiClient;
            this.orientationDelegate = orientationDelegate;
            this.closeDelegate = closeDelegate;
            this.adLoader = adLoader;
            this.sessionData = sessionData;
        }

        @Override
        void clear() {
            super.clear();
            this.context = null;
            this.fullAdWidget = null;
        }

        protected PresentationResultHolder doInBackground(Void ... voids) {
            Pair<Advertisement, Placement> data;
            try {
                data = this.loadPresentationData(this.placementId, this.savedState);
            }
            catch (VungleException e) {
                return new PresentationResultHolder(e);
            }
            this.advertisement = (Advertisement)data.first;
            Placement placement = (Placement)data.second;
            if (!this.adLoader.canRenderAd(this.advertisement)) {
                Log.e((String)TAG, (String)"Advertisement is null or assets are missing");
                return new PresentationResultHolder(new VungleException(10));
            }
            JobDelegateAnalytics adAnalytics = new JobDelegateAnalytics(this.jobRunner);
            String appId = null;
            Cookie appIdCookie = this.repository.load("appId", Cookie.class).get();
            if (appIdCookie != null && !TextUtils.isEmpty((CharSequence)appIdCookie.getString("appId"))) {
                appId = appIdCookie.getString("appId");
            }
            VungleWebClient webClient = new VungleWebClient(this.advertisement, placement);
            File assetDir = this.repository.getAdvertisementAssetDirectory(this.advertisement.getId()).get();
            if (assetDir == null || !assetDir.isDirectory()) {
                Log.e((String)TAG, (String)"Advertisement assets dir is missing");
                return new PresentationResultHolder(new VungleException(26));
            }
            switch (this.advertisement.getAdType()) {
                case 0: {
                    MoatTracker tracker = MoatTracker.connect(this.fullAdWidget.videoView, this.apiClient.getMoatEnabled());
                    LocalAdPresenter localPresenter = new LocalAdPresenter(this.advertisement, placement, this.repository, new HandlerScheduler(), adAnalytics, tracker, webClient, this.optionsState, assetDir, this.sessionData, ActivityManager.getInstance());
                    LocalAdView localView = new LocalAdView(this.context, this.fullAdWidget, this.orientationDelegate, this.closeDelegate);
                    return new PresentationResultHolder(localView, localPresenter, webClient, tracker, appId);
                }
                case 1: {
                    MRAIDAdPresenter mraidPresenter = new MRAIDAdPresenter(this.advertisement, placement, this.repository, new HandlerScheduler(), adAnalytics, webClient, this.optionsState, assetDir, this.sessionData, ActivityManager.getInstance());
                    MRAIDAdView mraidView = new MRAIDAdView(this.context, this.fullAdWidget, this.orientationDelegate, this.closeDelegate);
                    return new PresentationResultHolder(mraidView, mraidPresenter, webClient, null, null);
                }
            }
            return new PresentationResultHolder(new VungleException(10));
        }

        @Override
        protected void onPostExecute(PresentationResultHolder result) {
            super.onPostExecute(result);
            if (!this.isCancelled() && this.fullscreenCallback != null) {
                if (result.exception != null) {
                    Log.e((String)TAG, (String)"Exception on creating presenter", (Throwable)result.exception);
                    this.fullscreenCallback.onResult((Pair<AdContract.AdView, AdContract.AdvertisementPresenter>)new Pair(null, null), result.exception);
                    return;
                }
                this.fullAdWidget.linkWebView(result.webClient, new JavascriptBridge(result.advertisementPresenter));
                if (result.tracker != null) {
                    ReactiveVideoTracker reactiveVideoTracker = (ReactiveVideoTracker)MoatFactory.create().createCustomTracker((MoatPlugin)new ReactiveVideoTrackerPlugin("vunglenativevideo893259554489"));
                    result.tracker.configure(this.placementId, this.advertisement, result.appId, reactiveVideoTracker);
                }
                this.fullscreenCallback.onResult((Pair<AdContract.AdView, AdContract.AdvertisementPresenter>)new Pair((Object)result.adView, (Object)result.advertisementPresenter), result.exception);
            }
        }
    }

    private static class PresentationResultHolder {
        private String appId;
        private AdContract.AdView adView;
        private AdContract.AdvertisementPresenter advertisementPresenter;
        private VungleException exception;
        private VungleWebClient webClient;
        private MoatTracker tracker;

        PresentationResultHolder(VungleException exception) {
            this.exception = exception;
        }

        PresentationResultHolder(AdContract.AdView adView, AdContract.AdvertisementPresenter advertisementPresenter, VungleWebClient webClient, MoatTracker tracker, String appId) {
            this.adView = adView;
            this.advertisementPresenter = advertisementPresenter;
            this.webClient = webClient;
            this.tracker = tracker;
            this.appId = appId;
        }
    }
}

