/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.text.TextUtils;
import android.util.Log;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.AdConfig;
import com.vungle.warren.DownloadCallbackWrapper;
import com.vungle.warren.HeaderBiddingCallback;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.OperationSequence;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.VisionController;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleSettings;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.downloader.AssetDownloadListener;
import com.vungle.warren.downloader.DownloadRequest;
import com.vungle.warren.downloader.Downloader;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.AdAsset;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.model.Placement;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.Callback;
import com.vungle.warren.network.Response;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.DownloadJob;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.ui.HackMraid;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.FileUtility;
import com.vungle.warren.utility.UnzipUtility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class AdLoader
implements OperationSequence.Callback {
    private static final String TAG = AdLoader.class.getCanonicalName();
    public static final long EXPONENTIAL_RATE = 2L;
    public static final long RETRY_DELAY = 2000L;
    public static final int RETRY_COUNT = 5;
    private final Map<String, Operation> loadOperations = new ConcurrentHashMap<String, Operation>();
    private final Map<String, Operation> pendingOperations = new ConcurrentHashMap<String, Operation>();
    private final OperationSequence sequence;
    @NonNull
    private final Repository repository;
    @NonNull
    private final Executors sdkExecutors;
    @NonNull
    private final VungleApiClient vungleApiClient;
    @NonNull
    private final CacheManager cacheManager;
    @NonNull
    private final Downloader downloader;
    @NonNull
    private final RuntimeValues runtimeValues;
    @Nullable
    private JobRunner jobRunner;
    @NonNull
    private final VungleStaticApi vungleApi;
    @NonNull
    private final VisionController visionController;

    public AdLoader(@NonNull Executors sdkExecutors, @NonNull Repository repository, @NonNull VungleApiClient vungleApiClient, @NonNull CacheManager cacheManager, @NonNull Downloader downloader, @NonNull RuntimeValues runtimeValues, @NonNull VungleStaticApi vungleApi, @NonNull VisionController visionController, @NonNull OperationSequence sequence) {
        this.sdkExecutors = sdkExecutors;
        this.repository = repository;
        this.vungleApiClient = vungleApiClient;
        this.cacheManager = cacheManager;
        this.downloader = downloader;
        this.runtimeValues = runtimeValues;
        this.vungleApi = vungleApi;
        this.visionController = visionController;
        this.sequence = sequence;
        sequence.init(this, this.loadOperations);
    }

    public synchronized void init(@NonNull JobRunner jobRunner) {
        this.jobRunner = jobRunner;
        this.downloader.init();
    }

    private boolean canReDownload(Advertisement advertisement) {
        if (advertisement == null || advertisement.getState() != 0 && advertisement.getState() != 1) {
            return false;
        }
        List<AdAsset> adAssets = this.repository.loadAllAdAssets(advertisement.getId()).get();
        if (adAssets == null || adAssets.size() == 0) {
            return false;
        }
        for (AdAsset asset : adAssets) {
            File file;
            if (!(asset.fileType == 1 ? !this.fileIsValid(file = new File(asset.localPath), asset) : TextUtils.isEmpty((CharSequence)asset.serverPath))) continue;
            return false;
        }
        return true;
    }

    @WorkerThread
    public boolean canPlayAd(Advertisement advertisement) {
        if (advertisement == null || advertisement.getState() != 1) {
            return false;
        }
        return this.hasAssetsFor(advertisement.getId());
    }

    @WorkerThread
    public boolean canRenderAd(Advertisement advertisement) {
        if (advertisement == null) {
            return false;
        }
        if (advertisement.getState() != 1 && advertisement.getState() != 2) {
            return false;
        }
        return this.hasAssetsFor(advertisement.getId());
    }

    @WorkerThread
    public synchronized void clear() {
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(this.loadOperations.keySet());
        ids.addAll(this.pendingOperations.keySet());
        for (String id : ids) {
            this.onError(this.loadOperations.remove(id), 25);
            this.onError(this.pendingOperations.remove(id), 25);
        }
        for (Operation op : this.sequence.removeAll()) {
            this.onError(op, 25);
        }
    }

    public synchronized boolean isLoading(String id) {
        if (this.sequence.contains(id)) {
            return true;
        }
        Operation op = this.loadOperations.get(id);
        return op != null && op.loading.get();
    }

    private void setLoading(String id, boolean loading) {
        Operation op = this.loadOperations.get(id);
        if (op != null) {
            op.loading.set(loading);
        }
    }

    public synchronized void loadPendingInternal(String id) {
        Operation op = this.pendingOperations.remove(id);
        if (op == null) {
            return;
        }
        this.load(op.delay(0L));
    }

    public synchronized void load(@NonNull Operation op) {
        if (this.jobRunner == null) {
            this.onError(op, 9);
            return;
        }
        Operation pending = this.pendingOperations.remove(op.id);
        if (pending != null) {
            op.merge(pending);
        }
        if (op.delay <= 0L) {
            this.sequence.offer(op);
        } else {
            this.pendingOperations.put(op.id, op);
            this.jobRunner.execute(DownloadJob.makeJobInfo(op.id).setDelay(op.delay).setUpdateCurrent(true));
        }
    }

    @Override
    public void onLoadNext(Operation op) {
        this.loadOperations.put(op.id, op);
        this.loadAd(op, new DownloadCallbackWrapper(this.sdkExecutors.getBackgroundExecutor(), new DownloadAdCallback()));
    }

    @Override
    public void onChangePriority(Operation op) {
        for (DownloadRequest request : op.requests) {
            request.setPriority(this.getAssetPriority(op.priority));
            this.downloader.updatePriority(request);
        }
    }

    private void onError(@Nullable Operation op, @VungleException.ExceptionCode int code) {
        if (op != null) {
            for (LoadAdCallback loadAdCallback : op.loadAdCallbacks) {
                loadAdCallback.onError(op.id, new VungleException(code));
            }
        }
    }

    private VungleException reposeCodeToVungleException(int code) {
        if (this.recoverableServerCode(code)) {
            return new VungleException(22);
        }
        return new VungleException(21);
    }

    private boolean recoverableServerCode(int code) {
        return code == 408 || 500 <= code && code < 600;
    }

    private VungleException retrofitToVungleException(Throwable throwable) {
        if (throwable instanceof UnknownHostException) {
            return new VungleException(11);
        }
        if (throwable instanceof IOException) {
            return new VungleException(20);
        }
        return new VungleException(11);
    }

    private void loadAd(final @NonNull Operation op, final @NonNull DownloadCallbackWrapper listener) {
        final long adRequestStartTimeStamp = System.currentTimeMillis();
        this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!AdLoader.this.vungleApi.isInitialized()) {
                    listener.onDownloadFailed(new VungleException(9), op.id, null);
                    return;
                }
                Placement placement = AdLoader.this.repository.load(op.id, Placement.class).get();
                if (placement == null) {
                    listener.onDownloadFailed(new VungleException(13), op.id, null);
                    return;
                }
                if (AdLoader.this.isSizeInvalid(placement, op.size)) {
                    listener.onDownloadFailed(new VungleException(28), op.id, null);
                    return;
                }
                Advertisement advertisement = AdLoader.this.repository.findValidAdvertisementForPlacement(placement.getId()).get();
                if (placement.getPlacementAdType() == 1 && advertisement != null && advertisement.getAdConfig().getAdSize() != op.size) {
                    try {
                        AdLoader.this.repository.deleteAdvertisement(advertisement.getId());
                    }
                    catch (DatabaseHelper.DBException e) {
                        listener.onDownloadFailed(new VungleException(26), op.id, null);
                        return;
                    }
                }
                if (advertisement != null && AdLoader.this.canPlayAd(advertisement)) {
                    AdLoader.this.sequence.reportFinished(op.id);
                    listener.onReady(op.id, placement, advertisement);
                } else if (AdLoader.this.canReDownload(advertisement)) {
                    Log.d((String)TAG, (String)"Found valid adv but not ready - downloading content");
                    VungleSettings settings = ((AdLoader)AdLoader.this).runtimeValues.settings.get();
                    if (settings == null || AdLoader.this.cacheManager.getBytesAvailable() < settings.getMinimumSpaceForAd()) {
                        if (advertisement.getState() != 4) {
                            try {
                                AdLoader.this.repository.saveAndApplyState(advertisement, op.id, 4);
                            }
                            catch (DatabaseHelper.DBException e) {
                                listener.onDownloadFailed(new VungleException(26), op.id, null);
                                return;
                            }
                        }
                        listener.onDownloadFailed(new VungleException(19), op.id, null);
                        return;
                    }
                    AdLoader.this.setLoading(op.id, true);
                    if (advertisement.getState() != 0) {
                        try {
                            AdLoader.this.repository.saveAndApplyState(advertisement, op.id, 0);
                        }
                        catch (DatabaseHelper.DBException e) {
                            listener.onDownloadFailed(new VungleException(26), op.id, null);
                            return;
                        }
                    }
                    advertisement.setAdRequestStartTime(adRequestStartTimeStamp);
                    advertisement.setAssetDownloadStartTime(System.currentTimeMillis());
                    AdLoader.this.downloadAdAssets(op, advertisement, listener);
                } else if (placement.getWakeupTime() > System.currentTimeMillis()) {
                    listener.onDownloadFailed(new VungleException(1), op.id, null);
                    Log.w((String)TAG, (String)("Placement " + placement.getId() + " is  snoozed"));
                    if (placement.isAutoCached()) {
                        Log.d((String)TAG, (String)("Placement " + placement.getId() + " is sleeping rescheduling it "));
                        AdLoader.this.loadEndless(placement, op.size, placement.getWakeupTime() - System.currentTimeMillis());
                    }
                } else {
                    VungleSettings settings;
                    Log.i((String)TAG, (String)("didn't find cached adv for " + op.id + " downloading "));
                    if (advertisement != null) {
                        try {
                            AdLoader.this.repository.saveAndApplyState(advertisement, op.id, 4);
                        }
                        catch (DatabaseHelper.DBException e) {
                            listener.onDownloadFailed(new VungleException(26), op.id, null);
                            return;
                        }
                    }
                    if ((settings = ((AdLoader)AdLoader.this).runtimeValues.settings.get()) != null && AdLoader.this.cacheManager.getBytesAvailable() < settings.getMinimumSpaceForAd()) {
                        listener.onDownloadFailed(new VungleException(placement.isAutoCached() ? 18 : 17), op.id, null);
                        return;
                    }
                    Log.d((String)TAG, (String)("No adv for placement " + placement.getId() + " getting new data "));
                    AdLoader.this.setLoading(op.id, true);
                    AdLoader.this.fetchAdMetadata(op, placement, listener);
                }
            }
        });
    }

    private boolean isSizeInvalid(Placement placement, AdConfig.AdSize size) {
        return placement.getPlacementAdType() == 1 && !AdConfig.AdSize.isBannerAdSize(size) || placement.getPlacementAdType() == 0 && AdConfig.AdSize.isBannerAdSize(size);
    }

    private void fetchAdMetadata(final @NonNull Operation op, @NonNull Placement placement, final @NonNull DownloadCallback downloadCallback) {
        final HeaderBiddingCallback bidTokenCallBack = this.runtimeValues.headerBiddingCallback.get();
        final long requestStartTime = System.currentTimeMillis();
        this.vungleApiClient.requestAd(op.id, AdConfig.AdSize.isBannerAdSize(op.size) ? op.size.getName() : "", placement.isHeaderBidding(), this.visionController.isEnabled() ? this.visionController.getPayload() : null).enqueue(new Callback<JsonObject>(){

            @Override
            public void onFailure(Call<JsonObject> call, Throwable e) {
                downloadCallback.onDownloadFailed(AdLoader.this.retrofitToVungleException(e), op.id, null);
            }

            @Override
            public void onResponse(Call<JsonObject> call, final Response<JsonObject> response) {
                AdLoader.this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Placement placement = AdLoader.this.repository.load(op.id, Placement.class).get();
                        if (placement == null) {
                            Log.e((String)TAG, (String)"Placement metadata not found for requested advertisement.");
                            downloadCallback.onDownloadFailed(new VungleException(2), op.id, null);
                            return;
                        }
                        if (!response.isSuccessful()) {
                            long retryAfterHeaderValue = AdLoader.this.vungleApiClient.getRetryAfterHeaderValue(response);
                            if (retryAfterHeaderValue > 0L && placement.isAutoCached()) {
                                AdLoader.this.loadEndless(placement, op.size, retryAfterHeaderValue);
                                downloadCallback.onDownloadFailed(new VungleException(14), op.id, null);
                                return;
                            }
                            Log.e((String)TAG, (String)"Failed to retrieve advertisement information");
                            downloadCallback.onDownloadFailed(AdLoader.this.reposeCodeToVungleException(response.code()), op.id, null);
                            return;
                        }
                        JsonObject jsonObject = (JsonObject)response.body();
                        Log.d((String)TAG, (String)("Ads Response: " + jsonObject));
                        if (jsonObject != null && jsonObject.has("ads") && !jsonObject.get("ads").isJsonNull()) {
                            JsonArray ads = jsonObject.getAsJsonArray("ads");
                            if (ads == null || ads.size() == 0) {
                                downloadCallback.onDownloadFailed(new VungleException(1), op.id, null);
                                return;
                            }
                            JsonObject ad = ads.get(0).getAsJsonObject();
                            try {
                                int state;
                                Advertisement advertisementInDB;
                                Advertisement advertisement = new Advertisement(ad);
                                if (AdLoader.this.visionController.isEnabled()) {
                                    JsonObject markup = ad.getAsJsonObject("ad_markup");
                                    if (JsonUtil.hasNonNull((JsonElement)markup, "data_science_cache")) {
                                        AdLoader.this.visionController.setDataScienceCache(markup.get("data_science_cache").getAsString());
                                    } else {
                                        AdLoader.this.visionController.setDataScienceCache(null);
                                    }
                                }
                                if ((advertisementInDB = AdLoader.this.repository.load(advertisement.getId(), Advertisement.class).get()) != null && ((state = advertisementInDB.getState()) == 0 || state == 1 || state == 2)) {
                                    Log.d((String)TAG, (String)"Operation Cancelled");
                                    downloadCallback.onDownloadFailed(new VungleException(25), op.id, null);
                                    return;
                                }
                                if (placement.isHeaderBidding() && bidTokenCallBack != null) {
                                    bidTokenCallBack.onBidTokenAvailable(op.id, advertisement.getBidToken());
                                }
                                AdLoader.this.repository.deleteAdvertisement(advertisement.getId());
                                Set<Map.Entry<String, String>> entries = advertisement.getDownloadableUrls().entrySet();
                                File destinationDir = AdLoader.this.getDestinationDir(advertisement);
                                if (destinationDir == null || !destinationDir.isDirectory()) {
                                    downloadCallback.onDownloadFailed(new VungleException(26), op.id, advertisement.getId());
                                    return;
                                }
                                for (Map.Entry<String, String> entry : entries) {
                                    if (URLUtil.isHttpsUrl((String)entry.getValue()) || URLUtil.isHttpUrl((String)entry.getValue())) {
                                        AdLoader.this.saveAsset(advertisement, destinationDir, entry.getKey(), entry.getValue());
                                        continue;
                                    }
                                    downloadCallback.onDownloadFailed(new VungleException(11), op.id, advertisement.getId());
                                    return;
                                }
                                if (!(placement.getPlacementAdType() != 1 || advertisement.getAdType() == 1 && "banner".equals(advertisement.getTemplateType()))) {
                                    downloadCallback.onDownloadFailed(new VungleException(1), op.id, advertisement.getId());
                                    return;
                                }
                                advertisement.getAdConfig().setAdSize(op.size);
                                advertisement.setAdRequestStartTime(requestStartTime);
                                advertisement.setAssetDownloadStartTime(System.currentTimeMillis());
                                AdLoader.this.repository.saveAndApplyState(advertisement, op.id, 0);
                                AdLoader.this.downloadAdAssets(op, advertisement, downloadCallback);
                            }
                            catch (IllegalArgumentException badAd) {
                                JsonObject admarkup = ad.getAsJsonObject("ad_markup");
                                if (admarkup.has("sleep")) {
                                    int sleep = admarkup.get("sleep").getAsInt();
                                    placement.snooze(sleep);
                                    try {
                                        AdLoader.this.repository.save(placement);
                                    }
                                    catch (DatabaseHelper.DBException ignored) {
                                        downloadCallback.onDownloadFailed(new VungleException(26), op.id, null);
                                        return;
                                    }
                                    if (placement.isAutoCached()) {
                                        AdLoader.this.loadEndless(placement, op.size, (long)sleep * 1000L);
                                    }
                                }
                                downloadCallback.onDownloadFailed(new VungleException(1), op.id, null);
                            }
                            catch (DatabaseHelper.DBException ignored) {
                                downloadCallback.onDownloadFailed(new VungleException(26), op.id, null);
                            }
                        } else {
                            downloadCallback.onDownloadFailed(new VungleException(1), op.id, null);
                        }
                    }
                });
            }
        });
    }

    @Nullable
    File getDestinationDir(Advertisement advertisement) {
        return this.repository.getAdvertisementAssetDirectory(advertisement.getId()).get();
    }

    void saveAsset(Advertisement advertisement, File destinationDir, String key, String url) throws DatabaseHelper.DBException {
        String path = destinationDir.getPath() + File.separator + key;
        int type = path.endsWith("postroll") || path.endsWith("template") ? 0 : 2;
        AdAsset adAsset = new AdAsset(advertisement.getId(), url, path);
        adAsset.status = 0;
        adAsset.fileType = type;
        this.repository.save(adAsset);
    }

    private void downloadAdAssets(Operation op, Advertisement advertisement, DownloadCallback downloadCallback) {
        this.sequence.reportFinished(op.id);
        op.requests.clear();
        for (Map.Entry<String, String> entry : advertisement.getDownloadableUrls().entrySet()) {
            if (!TextUtils.isEmpty((CharSequence)entry.getKey()) && !TextUtils.isEmpty((CharSequence)entry.getValue()) && URLUtil.isValidUrl((String)entry.getValue())) continue;
            downloadCallback.onDownloadFailed(new VungleException(11), op.id, null);
            Log.e((String)TAG, (String)("Aborting, Failed to download Ad assets for: " + advertisement.getId()));
            return;
        }
        DownloadCallbackWrapper callback = new DownloadCallbackWrapper(this.sdkExecutors.getUIExecutor(), downloadCallback);
        try {
            this.repository.save(advertisement);
        }
        catch (DatabaseHelper.DBException e) {
            downloadCallback.onDownloadFailed(new VungleException(26), op.id, advertisement.getId());
            return;
        }
        List<AdAsset> assets = this.repository.loadAllAdAssets(advertisement.getId()).get();
        if (assets == null) {
            callback.onDownloadFailed(new VungleException(26), op.id, advertisement.getId());
            return;
        }
        for (AdAsset asset : assets) {
            if (asset.status == 3) {
                if (this.fileIsValid(new File(asset.localPath), asset)) continue;
                if (asset.fileType == 1) {
                    callback.onDownloadFailed(new VungleException(24), op.id, advertisement.getId());
                    return;
                }
            }
            if (asset.status == 4 && asset.fileType == 0) continue;
            if (TextUtils.isEmpty((CharSequence)asset.serverPath)) {
                callback.onDownloadFailed(new VungleException(24), op.id, advertisement.getId());
                return;
            }
            DownloadRequest downloadRequest = this.getDownloadRequest(asset, op.priority);
            if (asset.status == 1) {
                this.downloader.cancelAndAwait(downloadRequest, 1000L);
                downloadRequest = this.getDownloadRequest(asset, op.priority);
            }
            Log.d((String)TAG, (String)("Starting download for " + asset));
            asset.status = 1;
            try {
                this.repository.save(asset);
            }
            catch (DatabaseHelper.DBException ignored) {
                callback.onDownloadFailed(new VungleException(26), op.id, advertisement.getId());
                return;
            }
            op.requests.add(downloadRequest);
        }
        if (op.requests.size() == 0) {
            this.onAssetDownloadFinished(op.id, callback, advertisement, Collections.EMPTY_LIST);
            return;
        }
        AssetDownloadListener downloadListener = this.getAssetDownloadListener(advertisement, op, callback);
        for (DownloadRequest downloadRequest : op.requests) {
            this.downloader.download(downloadRequest, downloadListener);
        }
    }

    private DownloadRequest getDownloadRequest(AdAsset asset, @Priority int priority) {
        return new DownloadRequest(3, this.getAssetPriority(priority), asset.serverPath, asset.localPath, false, asset.identifier);
    }

    @DownloadRequest.Priority
    private int getAssetPriority(@Priority int priority) {
        return Math.max(-2147483646, priority);
    }

    @NonNull
    private AssetDownloadListener getAssetDownloadListener(final Advertisement advertisement, final Operation op, final DownloadCallback callback) {
        return new AssetDownloadListener(){
            AtomicLong downloadCount;
            List<AssetDownloadListener.DownloadError> errors;
            {
                this.downloadCount = new AtomicLong(op.requests.size());
                this.errors = Collections.synchronizedList(new ArrayList());
            }

            @Override
            public void onError(final @NonNull AssetDownloadListener.DownloadError downloadError, final @Nullable DownloadRequest downloadRequest) {
                AdLoader.this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Log.e((String)TAG, (String)"Download Failed");
                        if (downloadRequest != null) {
                            AdAsset asset;
                            String id = downloadRequest.cookieString;
                            AdAsset adAsset = asset = TextUtils.isEmpty((CharSequence)id) ? null : AdLoader.this.repository.load(id, AdAsset.class).get();
                            if (asset != null) {
                                errors.add(downloadError);
                                asset.status = 2;
                                try {
                                    AdLoader.this.repository.save(asset);
                                }
                                catch (DatabaseHelper.DBException e) {
                                    errors.add(new AssetDownloadListener.DownloadError(-1, new VungleException(26), 4));
                                }
                            } else {
                                errors.add(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), 1));
                            }
                        } else {
                            errors.add(new AssetDownloadListener.DownloadError(-1, new RuntimeException("error in request"), 4));
                        }
                        if (downloadCount.decrementAndGet() <= 0L) {
                            AdLoader.this.onAssetDownloadFinished(op.id, callback, advertisement, errors);
                        }
                    }
                });
            }

            @Override
            public void onProgress(@NonNull AssetDownloadListener.Progress progress, @NonNull DownloadRequest downloadRequest) {
            }

            @Override
            public void onSuccess(final @NonNull File downloadedFile, final @NonNull DownloadRequest downloadRequest) {
                AdLoader.this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        AdAsset adAsset;
                        if (!downloadedFile.exists()) {
                            this.onError(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), 3), downloadRequest);
                            return;
                        }
                        String id = downloadRequest.cookieString;
                        AdAsset adAsset2 = adAsset = id == null ? null : AdLoader.this.repository.load(id, AdAsset.class).get();
                        if (adAsset == null) {
                            this.onError(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), 1), downloadRequest);
                            return;
                        }
                        adAsset.fileType = AdLoader.this.isZip(downloadedFile) ? 0 : 2;
                        adAsset.fileSize = downloadedFile.length();
                        adAsset.status = 3;
                        try {
                            AdLoader.this.repository.save(adAsset);
                        }
                        catch (DatabaseHelper.DBException e) {
                            this.onError(new AssetDownloadListener.DownloadError(-1, new VungleException(26), 4), downloadRequest);
                            return;
                        }
                        if (downloadCount.decrementAndGet() <= 0L) {
                            AdLoader.this.onAssetDownloadFinished(op.id, callback, advertisement, errors);
                        }
                    }
                });
            }
        };
    }

    private boolean isZip(File downloadedFile) {
        return downloadedFile.getName().equals("postroll") || downloadedFile.getName().equals("template");
    }

    private void onAssetDownloadFinished(@NonNull String placementId, @NonNull DownloadCallback callback, @NonNull Advertisement advertisement, @NonNull List<AssetDownloadListener.DownloadError> errors) {
        if (errors.isEmpty()) {
            List<AdAsset> assets = this.repository.loadAllAdAssets(advertisement.getId()).get();
            if (assets == null || assets.size() == 0) {
                callback.onDownloadFailed(new VungleException(24), placementId, advertisement.getId());
                return;
            }
            for (AdAsset asset : assets) {
                if (asset.status == 3) {
                    File f = new File(asset.localPath);
                    if (!this.fileIsValid(f, asset)) {
                        callback.onDownloadFailed(new VungleException(24), placementId, advertisement.getId());
                        return;
                    }
                    if (asset.fileType != 0) continue;
                    try {
                        this.unzipFile(advertisement, asset, f, assets);
                        continue;
                    }
                    catch (IOException e) {
                        this.downloader.dropCache(asset.serverPath);
                        callback.onDownloadFailed(new VungleException(24), placementId, advertisement.getId());
                        return;
                    }
                    catch (DatabaseHelper.DBException e) {
                        callback.onDownloadFailed(new VungleException(26), placementId, advertisement.getId());
                        return;
                    }
                }
                if (asset.fileType != 0 || asset.status == 4) continue;
                callback.onDownloadFailed(new VungleException(24), placementId, advertisement.getId());
                return;
            }
            if (advertisement.getAdType() == 1) {
                File destinationDir = this.getDestinationDir(advertisement);
                if (destinationDir == null || !destinationDir.isDirectory()) {
                    callback.onDownloadFailed(new VungleException(26), placementId, advertisement.getId());
                    return;
                }
                Log.d((String)TAG, (String)("saving MRAID for " + advertisement.getId()));
                advertisement.setMraidAssetDir(destinationDir);
                try {
                    this.repository.save(advertisement);
                }
                catch (DatabaseHelper.DBException e) {
                    callback.onDownloadFailed(new VungleException(26), placementId, advertisement.getId());
                    return;
                }
            }
            callback.onDownloadCompleted(placementId, advertisement.getId());
        } else {
            VungleException endError = null;
            for (AssetDownloadListener.DownloadError downloadError : errors) {
                if (VungleException.getExceptionCode(downloadError.cause) == 26) {
                    endError = new VungleException(26);
                    break;
                }
                VungleException error = this.recoverableServerCode(downloadError.serverCode) && downloadError.reason == 1 ? new VungleException(23) : (downloadError.reason == 0 ? new VungleException(23) : new VungleException(24));
                endError = error;
                if (endError.getExceptionCode() != 24) continue;
                break;
            }
            VungleException exception = endError;
            callback.onDownloadFailed(exception, placementId, advertisement.getId());
        }
    }

    public void load(String id, LoadAdCallback listener) {
        this.load(new Operation(id, AdConfig.AdSize.VUNGLE_DEFAULT, 0L, 2000L, 5, 0, 0, true, 0, listener));
    }

    public void load(String id, AdConfig adConfig, LoadAdCallback listener) {
        this.load(new Operation(id, adConfig.getAdSize(), 0L, 2000L, 5, 0, 0, true, 0, listener));
    }

    public void loadEndless(@NonNull Placement placement, @NonNull AdConfig.AdSize size, long delay) {
        if (this.isSizeInvalid(placement, size)) {
            return;
        }
        this.load(new Operation(placement.getId(), size, delay, 2000L, 5, 1, 0, false, placement.getAutoCachePriority(), new LoadAdCallback[0]));
    }

    public void loadEndless(@NonNull Placement placement, long delay) {
        this.loadEndless(placement, placement.getAdSize(), delay);
    }

    private void unzipFile(Advertisement advertisement, AdAsset zipAsset, final @NonNull File downloadedFile, List<AdAsset> allAssets) throws IOException, DatabaseHelper.DBException {
        File mraidJS;
        final ArrayList<String> existingPaths = new ArrayList<String>();
        for (AdAsset asset : allAssets) {
            if (asset.fileType != 2) continue;
            existingPaths.add(asset.localPath);
        }
        File destinationDir = this.getDestinationDir(advertisement);
        if (destinationDir == null || !destinationDir.isDirectory()) {
            throw new IOException("Unable to access Destination Directory");
        }
        List<File> extractedFiles = UnzipUtility.unzip(downloadedFile.getPath(), destinationDir.getPath(), new UnzipUtility.Filter(){

            @Override
            public boolean matches(String extractPath) {
                File toExtract = new File(extractPath);
                for (String existing : existingPaths) {
                    File existingFile = new File(existing);
                    if (existingFile.equals(toExtract)) {
                        return false;
                    }
                    if (!toExtract.getPath().startsWith(existingFile.getPath() + File.separator)) continue;
                    return false;
                }
                return true;
            }
        });
        if (downloadedFile.getName().equals("template") && (mraidJS = new File(destinationDir.getPath() + File.separator + "mraid.js")).exists()) {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(mraidJS, true)));
            HackMraid.apply(out);
            out.close();
        }
        for (File file : extractedFiles) {
            AdAsset extractedAsset = new AdAsset(advertisement.getId(), null, file.getPath());
            extractedAsset.fileSize = file.length();
            extractedAsset.fileType = 1;
            extractedAsset.parentId = zipAsset.identifier;
            extractedAsset.status = 3;
            this.repository.save(extractedAsset);
        }
        Log.d((String)TAG, (String)("Uzipped " + destinationDir));
        FileUtility.printDirectoryTree(destinationDir);
        zipAsset.status = 4;
        this.repository.save(zipAsset, new Repository.SaveCallback(){

            @Override
            public void onSaved() {
                AdLoader.this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtility.delete(downloadedFile);
                        }
                        catch (IOException e) {
                            Log.e((String)TAG, (String)"Error on deleting zip assets archive", (Throwable)e);
                        }
                    }
                });
            }

            @Override
            public void onError(Exception ignored) {
            }
        });
    }

    boolean hasAssetsFor(String adId) throws IllegalStateException {
        List<AdAsset> adAssets = this.repository.loadAllAdAssets(adId).get();
        if (adAssets == null || adAssets.size() == 0) {
            return false;
        }
        boolean isAllAssetAvailable = true;
        for (AdAsset adAsset : adAssets) {
            if (adAsset.fileType == 0) {
                if (adAsset.status == 4) continue;
                isAllAssetAvailable = false;
                break;
            }
            if (adAsset.status != 3) {
                isAllAssetAvailable = false;
                break;
            }
            File file = new File(adAsset.localPath);
            if (this.fileIsValid(file, adAsset)) continue;
            isAllAssetAvailable = false;
            break;
        }
        return isAllAssetAvailable;
    }

    private boolean fileIsValid(File file, AdAsset adAsset) {
        return file.exists() && file.length() == adAsset.fileSize;
    }

    @VisibleForTesting
    Collection<Operation> getPendingOperations() {
        return this.pendingOperations.values();
    }

    @VisibleForTesting
    Collection<Operation> getRunningOperations() {
        return this.loadOperations.values();
    }

    public void dropCache(String advertisementId) {
        List<AdAsset> adAssets = this.repository.loadAllAdAssets(advertisementId).get();
        if (adAssets == null) {
            Log.w((String)TAG, (String)"No assets found in ad cache to cleanup");
            return;
        }
        for (AdAsset asset : adAssets) {
            this.downloader.dropCache(asset.serverPath);
        }
    }

    private class DownloadAdCallback
    implements DownloadCallback {
        private DownloadAdCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDownloadCompleted(@NonNull String placementId, @NonNull String advertisementId) {
            AdLoader adLoader = AdLoader.this;
            synchronized (adLoader) {
                Advertisement advertisement;
                Log.d((String)TAG, (String)("download completed " + placementId));
                Placement placement = AdLoader.this.repository.load(placementId, Placement.class).get();
                if (placement == null) {
                    this.onDownloadFailed(new VungleException(13), placementId, advertisementId);
                    return;
                }
                Advertisement advertisement2 = advertisement = TextUtils.isEmpty((CharSequence)advertisementId) ? null : AdLoader.this.repository.load(advertisementId, Advertisement.class).get();
                if (advertisement == null) {
                    this.onDownloadFailed(new VungleException(11), placementId, advertisementId);
                    return;
                }
                advertisement.setFinishedDownloadingTime(System.currentTimeMillis());
                try {
                    AdLoader.this.repository.saveAndApplyState(advertisement, placementId, 1);
                }
                catch (DatabaseHelper.DBException e) {
                    this.onDownloadFailed(new VungleException(26), placementId, advertisementId);
                    return;
                }
                this.onReady(placementId, placement, advertisement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReady(@NonNull String id, @NonNull Placement placement, @NonNull Advertisement advertisement) {
            AdLoader adLoader = AdLoader.this;
            synchronized (adLoader) {
                Operation operation;
                AdLoader.this.setLoading(id, false);
                HeaderBiddingCallback headerBiddingCallback = ((AdLoader)AdLoader.this).runtimeValues.headerBiddingCallback.get();
                if (placement.isHeaderBidding() && headerBiddingCallback != null) {
                    headerBiddingCallback.adAvailableForBidToken(id, advertisement.getBidToken());
                }
                Log.i((String)TAG, (String)("found already cached valid adv, calling onAdLoad " + id + " callback "));
                InitCallback initCallback = ((AdLoader)AdLoader.this).runtimeValues.initCallback.get();
                if (placement.isAutoCached() && initCallback != null) {
                    initCallback.onAutoCacheAdAvailable(id);
                }
                if ((operation = (Operation)AdLoader.this.loadOperations.remove(id)) != null) {
                    placement.setAdSize(operation.size);
                    try {
                        AdLoader.this.repository.save(placement);
                    }
                    catch (DatabaseHelper.DBException e) {
                        this.onDownloadFailed(new VungleException(26), id, advertisement.getId());
                    }
                    for (LoadAdCallback loadAdCallback : operation.loadAdCallbacks) {
                        loadAdCallback.onAdLoad(id);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDownloadFailed(@NonNull VungleException exception, String placementId, String advertisementId) {
            AdLoader adLoader = AdLoader.this;
            synchronized (adLoader) {
                Advertisement advertisement;
                Operation op = (Operation)AdLoader.this.loadOperations.remove(placementId);
                AdLoader.this.sequence.reportFinished(placementId);
                Placement placement = AdLoader.this.repository.load(placementId, Placement.class).get();
                Advertisement advertisement2 = advertisement = advertisementId == null ? null : AdLoader.this.repository.load(advertisementId, Advertisement.class).get();
                if (placement == null) {
                    if (advertisement != null) {
                        try {
                            AdLoader.this.repository.saveAndApplyState(advertisement, placementId, 4);
                        }
                        catch (DatabaseHelper.DBException ignored) {
                            exception = new VungleException(26);
                        }
                    }
                    if (op != null) {
                        for (LoadAdCallback loadAdCallback : op.loadAdCallbacks) {
                            loadAdCallback.onError(placementId, exception);
                        }
                    }
                    AdLoader.this.setLoading(placementId, false);
                    return;
                }
                boolean canRetry = false;
                boolean stopInfinite = false;
                int state = 4;
                switch (exception.getExceptionCode()) {
                    case 20: 
                    case 22: {
                        canRetry = true;
                        break;
                    }
                    case 23: {
                        if (advertisement == null) break;
                        canRetry = true;
                        state = 0;
                        break;
                    }
                    case 1: 
                    case 14: 
                    case 25: {
                        stopInfinite = true;
                        break;
                    }
                }
                if (op == null || op.logError) {
                    Log.e((String)TAG, (String)("Failed to load Ad/Assets for " + placementId + ". Cause : "), (Throwable)exception);
                }
                AdLoader.this.setLoading(placementId, false);
                if (op != null) {
                    try {
                        if (op.policy == 0) {
                            if (op.retry < op.retryLimit && canRetry) {
                                if (advertisement != null) {
                                    AdLoader.this.repository.saveAndApplyState(advertisement, placementId, state);
                                }
                                AdLoader.this.load(op.delay(op.retryDelay).retryDelay(op.retryDelay * 2L).retry(op.retry + 1));
                                return;
                            }
                        } else if (op.policy == 1 && !stopInfinite) {
                            int retry = op.retry;
                            if (retry < op.retryLimit && canRetry) {
                                ++retry;
                            } else {
                                retry = 0;
                                state = 4;
                            }
                            if (advertisement != null) {
                                AdLoader.this.repository.saveAndApplyState(advertisement, placementId, state);
                            }
                            AdLoader.this.load(op.delay(op.retryDelay).retryDelay(op.retryDelay * 2L).retry(retry));
                            return;
                        }
                        if (advertisement != null) {
                            AdLoader.this.repository.saveAndApplyState(advertisement, placementId, 4);
                        }
                    }
                    catch (DatabaseHelper.DBException e) {
                        exception = new VungleException(26);
                    }
                    for (LoadAdCallback loadAdCallback : op.loadAdCallbacks) {
                        loadAdCallback.onError(placementId, exception);
                    }
                }
            }
        }
    }

    public static class Operation {
        final String id;
        @NonNull
        final AdConfig.AdSize size;
        long delay;
        long retryDelay;
        int retry;
        int retryLimit;
        int policy;
        @NonNull
        final Set<LoadAdCallback> loadAdCallbacks = new CopyOnWriteArraySet<LoadAdCallback>();
        @NonNull
        final AtomicBoolean loading;
        boolean logError;
        @Priority
        int priority;
        List<DownloadRequest> requests = new CopyOnWriteArrayList<DownloadRequest>();

        Operation(String id, @NonNull AdConfig.AdSize size, long delay, long retryDelay, int retryLimit, int policy, int retry, boolean logError, @Priority int priority, LoadAdCallback ... loadAdCallbacks) {
            this.id = id;
            this.delay = delay;
            this.retryDelay = retryDelay;
            this.retryLimit = retryLimit;
            this.policy = policy;
            this.retry = retry;
            this.loading = new AtomicBoolean();
            this.size = size;
            this.logError = logError;
            this.priority = priority;
            if (loadAdCallbacks != null) {
                this.loadAdCallbacks.addAll(Arrays.asList(loadAdCallbacks));
            }
        }

        Operation delay(long delay) {
            return new Operation(this.id, this.size, delay, this.retryDelay, this.retryLimit, this.policy, this.retry, this.logError, this.priority, this.loadAdCallbacks.toArray(new LoadAdCallback[0]));
        }

        Operation retryDelay(long retryDelay) {
            return new Operation(this.id, this.size, this.delay, retryDelay, this.retryLimit, this.policy, this.retry, this.logError, this.priority, this.loadAdCallbacks.toArray(new LoadAdCallback[0]));
        }

        Operation retry(int retry) {
            return new Operation(this.id, this.size, this.delay, this.retryDelay, this.retryLimit, this.policy, retry, this.logError, this.priority, this.loadAdCallbacks.toArray(new LoadAdCallback[0]));
        }

        void merge(Operation other) {
            this.delay = Math.min(this.delay, other.delay);
            this.retryDelay = Math.min(this.retryDelay, other.retryDelay);
            this.retryLimit = Math.min(this.retryLimit, other.retryLimit);
            this.policy = other.policy == 0 ? other.policy : this.policy;
            this.retry = Math.min(this.retry, other.retry);
            this.logError |= other.logError;
            this.priority = Math.min(this.priority, other.priority);
            this.loadAdCallbacks.addAll(other.loadAdCallbacks);
        }

        @NonNull
        public String toString() {
            return "id=" + this.id + " size=" + this.size.toString() + " priority=" + this.priority + " policy=" + this.policy + " retry=" + this.retry + "/" + this.retryLimit + " delay=" + this.delay + "->" + this.retryDelay + " log=" + this.logError;
        }
    }

    public static @interface Priority {
        public static final int HIGHEST = 0;
        public static final int HIGH = 1;
        public static final int LOWEST = Integer.MAX_VALUE;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReschedulePolicy {
        public static final int EXPONENTIAL = 0;
        public static final int EXPONENTIAL_ENDLESS_AD = 1;
    }

    static interface DownloadCallback {
        public void onDownloadCompleted(@NonNull String var1, @NonNull String var2);

        public void onDownloadFailed(@NonNull VungleException var1, @Nullable String var2, @Nullable String var3);

        public void onReady(@NonNull String var1, @NonNull Placement var2, @NonNull Advertisement var3);
    }
}

