/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdLoader;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.VisionController;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.tasks.SendReportsJob;
import com.vungle.warren.ui.contract.AdContract;
import java.util.Map;

public class AdEventListener
implements AdContract.AdvertisementPresenter.EventListener {
    private static final String TAG = AdEventListener.class.getCanonicalName();
    private final Repository repository;
    private final AdLoader adLoader;
    private final JobRunner jobRunner;
    private final VisionController visionController;
    private final Map<String, Boolean> playOperations;
    private final PlayAdCallback playAdCallback;
    private final String placementId;
    private boolean successfulView;
    private int percentViewed = -1;
    private boolean adRewarded;
    private Placement placement;
    private Advertisement advertisement;

    AdEventListener(@NonNull String placementId, @NonNull Map<String, Boolean> playOperations, @Nullable PlayAdCallback playAdCallback, @NonNull Repository repository, @NonNull AdLoader adLoader, @NonNull JobRunner jobRunner, @NonNull VisionController visionController, @Nullable Placement placement, @Nullable Advertisement advertisement) {
        this.placementId = placementId;
        this.playOperations = playOperations;
        this.playAdCallback = playAdCallback;
        this.repository = repository;
        this.adLoader = adLoader;
        this.jobRunner = jobRunner;
        this.visionController = visionController;
        this.placement = placement;
        this.advertisement = advertisement;
        playOperations.put(placementId, true);
    }

    @Override
    public void onNext(@NonNull String s, String value, String id) {
        if (this.advertisement == null) {
            this.advertisement = this.repository.findValidAdvertisementForPlacement(this.placementId).get();
            if (this.advertisement == null) {
                Log.e((String)TAG, (String)"No Advertisement for ID");
                this.onFinished();
                if (this.playAdCallback != null) {
                    this.playAdCallback.onError(this.placementId, new VungleException(10));
                }
                return;
            }
        }
        if (this.placement == null) {
            this.placement = this.repository.load(this.placementId, Placement.class).get();
            if (this.placement == null) {
                Log.e((String)TAG, (String)"No Placement for ID");
                this.onFinished();
                if (this.playAdCallback != null) {
                    this.playAdCallback.onError(this.placementId, new VungleException(13));
                }
                return;
            }
        }
        try {
            if (s.equals("start")) {
                this.repository.saveAndApplyState(this.advertisement, id, 2);
                if (this.playAdCallback != null) {
                    this.playAdCallback.onAdStart(id);
                }
                this.percentViewed = 0;
                this.placement = this.repository.load(this.placementId, Placement.class).get();
                if (this.placement != null && this.placement.isAutoCached()) {
                    this.adLoader.loadEndless(this.placement, 0L);
                }
                if (this.visionController.isEnabled()) {
                    this.visionController.reportData(this.advertisement.getCreativeId(), this.advertisement.getCampaignId(), this.advertisement.getAdvertiserAppId());
                }
            } else if (s.equals("end")) {
                Log.d((String)"Vungle", (String)("Cleaning up metadata and assets for placement " + id + " and advertisement " + this.advertisement.getId()));
                this.repository.saveAndApplyState(this.advertisement, id, 3);
                this.repository.updateAndSaveReportState(id, this.advertisement.getAppID(), 0, 1);
                this.jobRunner.execute(SendReportsJob.makeJobInfo(false));
                this.onFinished();
                if (this.playAdCallback != null) {
                    this.playAdCallback.onAdEnd(id, this.successfulView || this.percentViewed >= 80, value != null && value.equals("isCTAClicked"));
                    this.playAdCallback.onAdEnd(id);
                }
            } else if (this.placement.isIncentivized() && s.equals("successfulView")) {
                this.successfulView = true;
                if (!this.adRewarded) {
                    this.adRewarded = true;
                    if (this.playAdCallback != null) {
                        this.playAdCallback.onAdRewarded(id);
                    }
                }
            } else if (this.placement.isIncentivized() && s.startsWith("percentViewed")) {
                String[] tokens = s.split(":");
                if (tokens.length == 2) {
                    String percentString = tokens[1];
                    this.percentViewed = Integer.parseInt(percentString);
                }
                if (!this.adRewarded && this.percentViewed >= 80) {
                    this.adRewarded = true;
                    if (this.playAdCallback != null) {
                        this.playAdCallback.onAdRewarded(id);
                    }
                }
            } else if ("open".equals(s) && this.playAdCallback != null) {
                if ("adClick".equals(value)) {
                    this.playAdCallback.onAdClick(id);
                } else if ("adLeftApplication".equals(value)) {
                    this.playAdCallback.onAdLeftApplication(id);
                }
            }
        }
        catch (DatabaseHelper.DBException ignored) {
            this.onError(new VungleException(26), id);
        }
    }

    @Override
    public void onError(VungleException exception, String placementId) {
        if (this.advertisement == null) {
            this.advertisement = this.repository.findValidAdvertisementForPlacement(placementId).get();
        }
        if (this.advertisement != null && exception.getExceptionCode() == 27) {
            this.adLoader.dropCache(this.advertisement.getId());
            return;
        }
        if (this.advertisement != null && exception.getExceptionCode() != 15 && exception.getExceptionCode() != 25) {
            try {
                this.repository.saveAndApplyState(this.advertisement, placementId, 4);
            }
            catch (DatabaseHelper.DBException e) {
                exception = new VungleException(26);
            }
        }
        this.onFinished();
        if (this.playAdCallback != null) {
            this.playAdCallback.onError(placementId, exception);
        }
    }

    protected void onFinished() {
        this.playOperations.put(this.placementId, false);
    }
}

