package com.vungle.warren.utility;

import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.error.VungleException;

import java.lang.ref.WeakReference;

public class WeakLoadAdCallback implements LoadAdCallback {
    private WeakReference<LoadAdCallback> weak;

    public WeakLoadAdCallback(LoadAdCallback callback) {
        this.weak = new WeakReference<>(callback);
    }

    @Override
    public void onAdLoad(String id) {
        LoadAdCallback callback = weak.get();
        if (callback != null) {
            callback.onAdLoad(id);
        }
    }

    @Override
    public void onError(String id, VungleException exception) {
        LoadAdCallback callback = weak.get();
        if (callback != null) {
            callback.onError(id, exception);
        }
    }
}
