package com.vungle.warren.utility;

import android.os.Build;
import android.os.Looper;

/**
 * Utility class for threading env
 */
public class ThreadUtil {

    /**
     * Checks if thread where this method is called is main.
     *
     * @return {@code true} if current thread is main {@code false} otherwise
     */
    public static boolean isMainThread() {
        Looper mainLooper = Looper.getMainLooper();

        if (mainLooper == null)
            return false;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
            return mainLooper.isCurrentThread();

        Looper myLooper = Looper.myLooper();

        return myLooper != null && mainLooper.getThread().equals(myLooper.getThread());
    }

}
