package com.vungle.warren.utility;

import android.os.Handler;
import androidx.annotation.NonNull;

/**
 * Extension of Handler that manages pausing and resuming of repeating interval runnable tasks
 */
public class RefreshHandler extends Handler {

    private static final int ID = 0;
    private static final int DISABLE_REFRESH_VALUE = 0;     //0 means refresh is disabled

    private long handlerStartTime;
    private long handlerTimeElapsed;
    private final long refreshDuration;

    private Runnable runnable;

    /**
     * RefreshHandler designed to only handle 1 runnable at a time
     *
     * @param refreshInterval - how often to refresh the runnable in millis
     */
    public RefreshHandler(@NonNull Runnable runnable, long refreshInterval) {
        this.refreshDuration = refreshInterval;
        this.runnable = runnable;
    }

    public synchronized void pause() {
        if (hasMessages(ID)) {
            handlerTimeElapsed = handlerTimeElapsed + (System.currentTimeMillis() - handlerStartTime);

            this.removeMessages(ID);
            this.removeCallbacks(runnable);
        }
    }

    public synchronized void start() {
        if (refreshDuration <= DISABLE_REFRESH_VALUE) {
            //if zero do not start
            return;
        }

        if (!hasMessages(ID)) {
            long delay = refreshDuration - handlerTimeElapsed;
            handlerStartTime = System.currentTimeMillis();
            postDelayed(runnable, delay);
        }

    }

    public synchronized void clean() {
        this.removeMessages(ID);
        this.removeCallbacks(runnable);
        handlerTimeElapsed = 0;
        handlerStartTime = 0;
    }
}
