package com.vungle.warren.utility;

import androidx.annotation.NonNull;


public abstract class PriorityRunnable implements Comparable, Runnable {

    //Higher priority goes first
    @Override
    public int compareTo(@NonNull Object o) {

        if (o instanceof PriorityRunnable) {
            Integer current = getPriority();
            Integer incoming = ((PriorityRunnable) o).getPriority();

            return incoming.compareTo(current);
        }

        return -1;
    }

    public abstract Integer getPriority();

}
