package com.vungle.warren.utility;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class ExternalRouter {

    public static final String TAG = ExternalRouter.class.getSimpleName();

    public static boolean launch(@Nullable String url, @NonNull Context context) {
        if (TextUtils.isEmpty(url) || context == null) {
            return false;
        }
        try {
            Intent i = Intent.parseUri(url, 0);
            i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            ActivityManager.startWhenForeground(context, i);
            return true;
        } catch (Exception e) {
            Log.e(TAG, "Error while opening url" + e.getLocalizedMessage());
        }

        Log.d(TAG, "Cannot open url " + url);
        return false;
    }
}
