package com.vungle.warren.ui.view;

import androidx.annotation.Nullable;
import androidx.annotation.NonNull;
import android.webkit.WebView;
import android.webkit.WebViewRenderProcess;

import com.google.gson.JsonObject;


public interface WebViewAPI {

    void setConsentStatus(boolean collectedConsent, @Nullable String title,
                          @Nullable String message, @Nullable String accept, @Nullable String deny);

    void setMRAIDDelegate(MRAIDDelegate MRAIDDelegate);

    void notifyPropertiesChange(boolean skipCmdQueue);

    void setAdVisibility(boolean isViewable);

    void setErrorHandler(WebClientErrorHandler errorHandler);

    /**
     * Contract for any object which wishes to process commands from an MRAID container. It defines
     * a single method which will be invoked whenever the MRAID container calls a method the SDK
     * needs to handle.
     */
    interface MRAIDDelegate {
        /**
         * Process the incoming command from the MRAID container. If the command was processed, this
         * method will return true and the client will send back a notifyCommandComplete() call.
         *
         * @param command   The name of the command being invoked
         * @param arguments The arguments for the command.
         * @return <code>true</code> if the command was processed, <code>false</code> otherwise.
         */
        boolean processCommand(String command, JsonObject arguments);
    }

    /**
     * Callback interface to notify errors in WebViewAPI.
     */
    interface WebClientErrorHandler {
        /**
         * Callback method.
         *
         * @param errorDesc Error to be notified.
         */
        void onReceivedError(String errorDesc);

        /**
         * Callback when rendering process is gone. This indicates that we cannot proceed with
         * WebView and it should be removed. Otherwise, app will crash.
         *
         * @return <code>true</code> if the case was handled, <code>false</code> otherwise.
         */
        boolean onWebRenderingProcessGone(WebView view, boolean didCrash);

        /**
         * Callback when rendering process becomes unresponsive to user inputs or web navigation
         *
         * @param webView              the webview that became unresponsive
         * @param webViewRenderProcess the renderer process
         */
        void onRenderProcessUnresponsive(@NonNull WebView webView, @Nullable WebViewRenderProcess webViewRenderProcess);
    }

}
