package com.vungle.warren.ui.view;

import android.os.Build;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;

import com.vungle.warren.BuildConfig;

public class WebSettingsUtils {

    public static void applyDefault(WebView webView){
        final WebSettings webSettings = webView.getSettings();
        webSettings.setBuiltInZoomControls(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setSaveFormData(true);
        webSettings.setUseWideViewPort(false);
        webSettings.setAllowFileAccess(true);

        if (BuildConfig.DEBUG && Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            webView.setWebContentsDebuggingEnabled(true);
        }

        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.KITKAT) {
            webView.setVisibility(View.INVISIBLE);
        }
    }

}
