package com.vungle.warren.ui.contract;

import com.vungle.warren.ui.presenter.LocalAdPresenter;

import java.io.File;

public interface LocalAdContract {
    /**
     * Interface that allows us to define an AdView, whether it be a fragment, Activity, or custom View.
     * This allows our {@link LocalPresenter} to render the ad in any
     * container that adheres to this contract.
     */
    interface LocalView extends AdContract.AdView<LocalAdPresenter> {

        /**
         * If ad is local, give option to configure a CTA overlay button for users to quickly skip the end card
         * and download the ad
         *
         * @param ctaOverlayEnabled      true to enable (show) button, false to disable (hide)
         * @param ctaClickAreaEnabled    true to enable click on video else false
         *                               if ctaOverlayEnabled video is clickable, regardless of ctaClickAreaEnabled
         */
        void showCTAOverlay(boolean ctaOverlayEnabled, boolean ctaClickAreaEnabled);

        /**
         * Play the given video in the view. It is assumed that the given video can be rendered without
         * transcoding or further processing by the view.
         *
         * @param file       The video file.
         * @param startMuted For Local Videos Only, developers are able to specify if videos should start muted
         */
        void playVideo(File file, boolean startMuted, int videoPosition);

        void pauseVideo();

        boolean isVideoPlaying();

        int getVideoPosition();

        boolean isDialogVisible();
    }

    /**
     * Advertisement Rendering contract. This Presenter interface defines the way that we render advertisements
     * into a view using the {@link com.vungle.warren.model.Advertisement} model.
     */
    interface LocalPresenter extends AdContract.AdvertisementPresenter<LocalView> {

        /**
         * @param position
         */
        void onProgressUpdate(int position, float duration);

        void onVideoStart(int position, float duration);

        void onMute(boolean muted);

        void onDownload();

        boolean onMediaError(String description);

        void onPrivacy();

    }
}
