package com.vungle.warren.ui;


import android.os.Build;
import android.util.Log;

public class VungleFlexViewActivity extends VungleActivity {

    private static final String TAG = VungleFlexViewActivity.class.getSimpleName();

    @Override
    protected boolean canRotate() {

        // Android changes cause crash, they were fixed later. Changes are added in 26 but applied only if target is 27,
        // we can't have transcluent or floating windows to set orientation
        // https://android.googlesource.com/platform/frameworks/base/+/master/services/core/java/com/android/server/am/ActivityRecord.java#2188
        // and changed it later
        // https://android.googlesource.com/platform/frameworks/base/+/d4ecffae67fa0dea03c581ca26f76b87a14be763%5E%21/
        // Vungle bug - AND-1463
        boolean blockRotate = getApplication().getApplicationInfo().targetSdkVersion >= Build.VERSION_CODES.O_MR1
                && Build.VERSION.SDK_INT == Build.VERSION_CODES.O;
        Log.d(TAG, "allow rotation = " + !blockRotate);

        return !blockRotate;
    }
}
