package com.vungle.warren.ui;

import com.vungle.warren.model.Placement;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.utility.ActivityManager;

import androidx.annotation.Nullable;

public class PresenterAppLeftCallback implements ActivityManager.LeftApplicationCallback {
    private final AdContract.AdvertisementPresenter.EventListener bus;
    private final Placement placement;

    public PresenterAppLeftCallback(@Nullable AdContract.AdvertisementPresenter.EventListener bus,
                                    @Nullable Placement placement) {
        this.bus = bus;
        this.placement = placement;
    }

    @Override
    public void onLeftApplication() {
        if (bus != null) {
            bus.onNext("open", "adLeftApplication", placement == null ? null : placement.getId());
        }
    }
}
