package com.vungle.warren.ui;

import androidx.annotation.NonNull;

import com.vungle.warren.model.Report;
import com.vungle.warren.persistence.Repository;

import java.util.concurrent.atomic.AtomicBoolean;

public class DurationRecorder {
    private final Report report;
    private final Repository repository;
    private final Repository.SaveCallback repoCallback;
    private AtomicBoolean paused = new AtomicBoolean(true);
    private long startMillis;

    public DurationRecorder(
            @NonNull Report report,
            @NonNull Repository repository,
            @NonNull Repository.SaveCallback repoCallback) {
        this.report = report;
        this.repository = repository;
        this.repoCallback = repoCallback;
    }

    public void start() {
        if (paused.getAndSet(false)) {
            startMillis = System.currentTimeMillis() - report.getAdDuration();
        }
    }

    public void stop() {
        if (!paused.getAndSet(true)) {
            save();
        }
    }

    public void update() {
        if (!paused.get()) {
            save();
        }
    }

    private void save() {
        report.setAdDuration(System.currentTimeMillis() - startMillis);
        repository.save(report, repoCallback);
    }
}
