package com.vungle.warren.tasks;

import android.os.Bundle;
import androidx.annotation.NonNull;

/**
 * The reconfig job requests a new config from the ad server and updates the state of the SDK accordingly.
 */
public class ReconfigJob implements Job {

    public static final String TAG = ReconfigJob.class.getCanonicalName();
    private ReconfigCall reconfigCall;

    public ReconfigJob(@NonNull ReconfigCall reconfigCall) {
        this.reconfigCall = reconfigCall;
    }

//    /**
//     * Schedule a reconfiguration job to execute later.
//     *
//     * @param sleepMillis The amount of time to wait before firing off the reconfiguration job, in
//     *                    milliseconds.
//     */
    public static JobInfo makeJobInfo(String appID) {
        Bundle extras = new Bundle();
        extras.putString("appID", appID);

        return new JobInfo(TAG)
                .setExtras(extras)
                .setUpdateCurrent(true)
                .setPriority(JobInfo.Priority.HIGHEST);
    }


    @Override
    public int onRunJob(Bundle params, JobRunner jobRunner) {
        String appID = params.getString("appID", null);
        if (appID == null) {
            /// Without an appID, we cannot reconfigure the SDK. This is a developer error.
            return Result.FAILURE;
        }

        reconfigCall.reConfigVungle();

        /// We were able to call init(), so our work here is done. The next job is scheduled by the
        /// Vungle.init() method based on the response from the Ad Server.
        return Result.SUCCESS;
    }

    public interface ReconfigCall {

        void reConfigVungle();
    }
}
