package com.vungle.warren.tasks;

import android.os.Bundle;
import androidx.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface Job {

    @IntDef({Result.SUCCESS, Result.FAILURE, Result.RESCHEDULE})
    @Retention(RetentionPolicy.SOURCE)
    @interface Result {
        int SUCCESS = 0;
        int FAILURE = 1;
        int RESCHEDULE = 2;
    }

    @Result
    int onRunJob(Bundle bundle, JobRunner jobRunner);
}
