package com.vungle.warren.persistence;


import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.vungle.warren.BuildConfig;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureResult<T> implements Future<T> {
    public static final String TAG = FutureResult.class.getSimpleName();

    private final Future<T> future;

    public FutureResult(Future<T> future) {
        this.future = future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return future.isDone();
    }

    @Override
    @Nullable
    public T get() {
        T result = null;

        try {
            result = future.get();
        } catch (InterruptedException e) {
            Log.w(TAG, "future.get() Interrupted on Thread " + Thread.currentThread().getName());
            Thread.currentThread().interrupt();
        } catch (ExecutionException e) {
            Log.e(TAG, "error on execution", e);
            if (BuildConfig.DEBUG) throw new RuntimeException(e);
        }

        return result;
    }

    @Override
    @Nullable
    public T get(long timeout, @NonNull TimeUnit unit){
        T result = null;

        try {
            result = future.get(timeout, unit);
        } catch (InterruptedException e) {
            Log.w(TAG, "future.get() Interrupted on Thread " + Thread.currentThread().getName());
            Thread.currentThread().interrupt();
        } catch (ExecutionException e) {
            Log.e(TAG, "error on execution", e);
            if (BuildConfig.DEBUG) throw new RuntimeException(e);
        } catch (TimeoutException e) {
            if (BuildConfig.DEBUG) e.printStackTrace();
            Log.w(TAG, "future.get() Timeout on Thread " + Thread.currentThread().getName());
        }

        return result;
    }

}
