package com.vungle.warren.persistence;

import java.io.File;
import java.io.IOException;

/**
 * The designer interface is the contract for any class that wishes to manage asset objects
 * on disk. It is responsible for creating assets, their directories, persisting them and retrieving
 * them.
 */
public interface Designer {

     /**
     * Get the directory for the assets by identifier.
     * @param identifier The asset collection identifier.
     * @throws IllegalStateException
     */
    File getAssetDirectory(String identifier) throws IllegalStateException;

    /**
     * Deletes the assets for the matching identifier, if they exist.
     * @param identifier Assets matching this identifier will be deleted.
     * @throws IOException if assets for the given placement could not be deleted.
     */
    void deleteAssets(String identifier) throws IOException;

    /**
     * Get the directory where this Designer stores the asset files. This can be used to
     * @return The directory where this designer will store the asset files.
     * @throws IllegalStateException
     */
    File getCacheDirectory() throws IllegalStateException;

    void clearCache();
}
