package com.vungle.warren.persistence;

import android.content.ContentValues;
import androidx.annotation.NonNull;

/**
 * A class that used for mapping model from/to db
 */
public interface DBAdapter<T> {

    /**
     * Generates {@link ContentValues} for item
     *
     * @return content values
     */
    ContentValues toContentValues(T item);

    /**
     * Generates model from {@link ContentValues}
     *
     * @return model
     */
    @NonNull
    T fromContentValues(ContentValues values);

    /**
     * @return model table name
     */
    String tableName();
}
