package com.vungle.warren.persistence;

import android.content.ContentValues;

public class ContentValuesUtil {

    public static boolean getBoolean(ContentValues contentValues, String name) {
        Object value = contentValues.get(name);
        try {
            if (value == null) {
                return false;
            }
            return (Boolean) value;
        } catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                // Note that we also check against 1 here because SQLite's internal representation
                // for booleans is an integer with a value of 0 or 1. Without this check, boolean
                // values obtained via DatabaseUtils#cursorRowToContentValues will always return
                // false.
                return Boolean.valueOf(value.toString()) || "1".equals(value);
            } else if (value instanceof Number) {
                return ((Number) value).intValue() != 0;
            } else {
                return false;
            }
        }
    }
}
