/*
 * Copyright (C) 2015 Square, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Modifications copyright (C) 2019 Vungle, Inc.
 */
package com.vungle.warren.network.converters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.vungle.warren.network.converters.Converter;

import java.io.IOException;

import okhttp3.ResponseBody;

public class JsonConverter implements Converter<ResponseBody, JsonObject> {

    private static final Gson gson = new GsonBuilder().create();

    @Override
    public JsonObject convert(ResponseBody value) throws IOException {
        try {
            String response = value.string();
            return gson.fromJson(response, JsonObject.class);
        } finally {
            value.close();
        }
    }
}
