package com.vungle.warren.network;


import com.google.gson.JsonObject;

import java.util.Map;

import androidx.annotation.Keep;


/**
 * Contract definition between the client and the server for the Vungle API. The endpoint paths
 * are dynamic and set by the response of the config endpoint.
 */
@Keep
public interface VungleApi {

    Call<JsonObject> config(String ua, JsonObject body);

    Call<JsonObject> reportNew(String ua, String path, Map<String, String> query);

    Call<JsonObject> ads(String ua, String path, JsonObject body);

    Call<JsonObject> willPlayAd(String ua, String path, JsonObject body);

    Call<JsonObject> ri(String ua, String path, JsonObject body);

    Call<JsonObject> reportAd(String ua, String path, JsonObject body);

    Call<Void> pingTPAT(String ua, String url);

}
