package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;

import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

public class VisionDataDBAdapter implements DBAdapter<VisionData> {
    @Override
    public ContentValues toContentValues(VisionData item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(VisionDataColumns.COLUMN_TIMESTAMP, item.timestamp);
        contentValues.put(VisionDataColumns.COLUMN_CREATIVE, item.creative);
        contentValues.put(VisionDataColumns.COLUMN_CAMPAIGN, item.campaign);
        contentValues.put(VisionDataColumns.COLUMN_ADVERTISER, item.advertiser);
        return contentValues;
    }

    @NonNull
    @Override
    public VisionData fromContentValues(ContentValues values) {
        return new VisionData(
                values.getAsLong(VisionDataColumns.COLUMN_TIMESTAMP),
                values.getAsString(VisionDataColumns.COLUMN_CREATIVE),
                values.getAsString(VisionDataColumns.COLUMN_CAMPAIGN),
                values.getAsString(VisionDataColumns.COLUMN_ADVERTISER));
    }

    @Override
    public String tableName() {
        return VisionDataColumns.TABLE_NAME;
    }

    public interface VisionDataColumns extends IdColumns {
        String TABLE_NAME = "vision_data";
        String COLUMN_TIMESTAMP = "timestamp";
        String COLUMN_CREATIVE = "creative";
        String COLUMN_CAMPAIGN = "campaign";
        String COLUMN_ADVERTISER = "advertiser";
    }

    public static final String CREATE_VISION_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + VisionDataColumns.TABLE_NAME
            + "("
            + VisionDataColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT, "
            + VisionDataColumns.COLUMN_TIMESTAMP + " NUMERIC, "
            + VisionDataColumns.COLUMN_CREATIVE + " TEXT, "
            + VisionDataColumns.COLUMN_CAMPAIGN + " TEXT, "
            + VisionDataColumns.COLUMN_ADVERTISER + " TEXT "
            + ")";
}
