package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;

import com.vungle.warren.AdConfig;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

import static com.vungle.warren.persistence.ContentValuesUtil.getBoolean;

public class PlacementDBAdapter implements DBAdapter<Placement> {

    @Override
    public ContentValues toContentValues(Placement item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(PlacementColumns.COLUMN_IDENTIFIER, item.identifier);
        contentValues.put(PlacementColumns.COLUMN_INCENTIVIZED, item.incentivized);
        contentValues.put(PlacementColumns.COLUMN_HEADERBIDDING, item.headerBidding);
        contentValues.put(PlacementColumns.COLUMN_AUTOCACHED, item.autoCached);
        contentValues.put(PlacementColumns.COLUMN_WAKEUP_TIME, item.wakeupTime);
        contentValues.put(PlacementColumns.COLUMN_IS_VALID, item.isValid);
        contentValues.put(PlacementColumns.COLUMN_REFRESH_DURATION, item.adRefreshDuration);
        contentValues.put(PlacementColumns.COLUMN_SUPPORTED_TEMPLATE_TYPES, item.placementAdType);
        contentValues.put(PlacementColumns.COLUMN_AD_SIZE, item.getAdSize().getName());
        contentValues.put(PlacementColumns.COLUMN_AUTOCACHE_PRIORITY, item.autoCachePriority);
        return contentValues;
    }

    @NonNull
    @Override
    public Placement fromContentValues(ContentValues values) {
        Placement placement = new Placement();
        placement.identifier = values.getAsString(PlacementColumns.COLUMN_IDENTIFIER);
        placement.wakeupTime = values.getAsLong(PlacementColumns.COLUMN_WAKEUP_TIME);

        placement.incentivized = getBoolean(values, PlacementColumns.COLUMN_INCENTIVIZED);
        placement.headerBidding = getBoolean(values, PlacementColumns.COLUMN_HEADERBIDDING);
        placement.autoCached = getBoolean(values, PlacementColumns.COLUMN_AUTOCACHED);
        placement.isValid = getBoolean(values, PlacementColumns.COLUMN_IS_VALID);
        placement.adRefreshDuration = values.getAsInteger(PlacementColumns.COLUMN_REFRESH_DURATION);
        placement.placementAdType = values.getAsInteger(PlacementColumns.COLUMN_SUPPORTED_TEMPLATE_TYPES);
        placement.adSize = AdConfig.AdSize.fromName(values.getAsString(PlacementColumns.COLUMN_AD_SIZE));
        placement.autoCachePriority = values.getAsInteger(PlacementColumns.COLUMN_AUTOCACHE_PRIORITY);
        return placement;
    }

    @Override
    public String tableName() {
        return PlacementColumns.TABLE_NAME;
    }

    public interface PlacementColumns extends IdColumns {
        String TABLE_NAME = "placement";
        String COLUMN_INCENTIVIZED = "incentivized";
        String COLUMN_HEADERBIDDING = "header_bidding";
        String COLUMN_AUTOCACHED = "auto_cached";
        String COLUMN_WAKEUP_TIME = "wakeup_time";
        String COLUMN_IS_VALID = "is_valid";
        String COLUMN_REFRESH_DURATION = "refresh_duration";
        String COLUMN_SUPPORTED_TEMPLATE_TYPES = "supported_template_types";
        String COLUMN_AD_SIZE = "ad_size";
        String COLUMN_AUTOCACHE_PRIORITY = "autocache_priority";
    }

    public static final String CREATE_PLACEMENT_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + PlacementDBAdapter.PlacementColumns.TABLE_NAME
            + "("
            + PlacementColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT, "
            + PlacementColumns.COLUMN_IDENTIFIER + " TEXT UNIQUE, "
            + PlacementColumns.COLUMN_INCENTIVIZED + " SHORT, "
            + PlacementColumns.COLUMN_AUTOCACHED + " SHORT, "
            + PlacementColumns.COLUMN_IS_VALID + " SHORT, "
            + PlacementColumns.COLUMN_WAKEUP_TIME + " NUMERIC, "
            + PlacementColumns.COLUMN_HEADERBIDDING + " SHORT, "
            + PlacementColumns.COLUMN_REFRESH_DURATION + " NUMERIC, "
            + PlacementColumns.COLUMN_SUPPORTED_TEMPLATE_TYPES + " NUMERIC, "
            + PlacementColumns.COLUMN_AD_SIZE + " TEXT, "
            + PlacementColumns.COLUMN_AUTOCACHE_PRIORITY + " NUMERIC"
            + ")";
}
