package com.vungle.warren.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import androidx.annotation.Nullable;

public class JsonUtil {

    public static boolean hasNonNull(@Nullable JsonElement jsonElement, String key) {
        if (jsonElement == null || jsonElement.isJsonNull() || !jsonElement.isJsonObject())
            return false;


        JsonObject object = jsonElement.getAsJsonObject();
        return object.has(key) && object.get(key) != null && !object.get(key).isJsonNull();
    }

}
