package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

import java.lang.reflect.Type;
import java.util.Map;

public class CookieDBAdapter implements DBAdapter<Cookie> {
    private Gson gson = new GsonBuilder().create();
    Type boolType = new TypeToken<Map<String, Boolean>>(){}.getType();
    Type intType = new TypeToken<Map<String, Integer>>(){}.getType();
    Type longType = new TypeToken<Map<String, Long>>(){}.getType();
    Type stringType = new TypeToken<Map<String, String>>(){}.getType();

    @Override
    public ContentValues toContentValues(Cookie item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(CookieColumns.COLUMN_IDENTIFIER, item.identifier);
        contentValues.put(CookieColumns.COLUMN_BOOLS, gson.toJson(item.booleans, boolType));
        contentValues.put(CookieColumns.COLUMN_INTS, gson.toJson(item.integers, intType));
        contentValues.put(CookieColumns.COLUMN_LONGS, gson.toJson(item.longs, longType));
        contentValues.put(CookieColumns.COLUMN_STRINGS, gson.toJson(item.strings, stringType));
        return contentValues;
    }

    @NonNull
    @Override
    public Cookie fromContentValues(ContentValues values) {
        Cookie cookie = new Cookie(values.getAsString(CookieColumns.COLUMN_IDENTIFIER));
        cookie.booleans = gson.fromJson(values.getAsString(CookieColumns.COLUMN_BOOLS), boolType);
        cookie.longs = gson.fromJson(values.getAsString(CookieColumns.COLUMN_LONGS), longType);
        cookie.integers = gson.fromJson(values.getAsString(CookieColumns.COLUMN_INTS), intType);
        cookie.strings = gson.fromJson(values.getAsString(CookieColumns.COLUMN_STRINGS), stringType);
        return cookie;
    }

    @Override
    public String tableName() {
        return CookieColumns.TABLE_NAME;
    }

    public interface CookieColumns extends IdColumns {
        String TABLE_NAME = "cookie";

        String COLUMN_INTS = "ints";
        String COLUMN_STRINGS = "strings";
        String COLUMN_LONGS = "longs";
        String COLUMN_BOOLS = "bools";
    }

    public static final String CREATE_COOKIE_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + CookieColumns.TABLE_NAME
            + "("
            + CookieColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT, "
            + CookieColumns.COLUMN_IDENTIFIER + " TEXT UNIQUE, "
            + CookieColumns.COLUMN_BOOLS + " TEXT, "
            + CookieColumns.COLUMN_INTS + " TEXT, "
            + CookieColumns.COLUMN_LONGS + " TEXT, "
            + CookieColumns.COLUMN_STRINGS + " TEXT "
            + ")";
}
