package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;
import android.util.Pair;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vungle.warren.AdConfig;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

import static com.vungle.warren.persistence.ContentValuesUtil.getBoolean;

/**
 * Created by Alexander Semenov on 22-Oct-18.
 */
public class AdvertisementDBAdapter implements DBAdapter<Advertisement> {

    private Gson gson = new GsonBuilder().create();
    private Type stringArrayType = new TypeToken<String[]>() {
    }.getType();
    private Type stringMapType = new TypeToken<Map<String, String>>() {
    }.getType();
    private Type checkpointListType = new TypeToken<List<Advertisement.Checkpoint>>() {
    }.getType();
    private Type cacheableMapType = new TypeToken<Map<String, Pair<String, String>>>() {
    }.getType();

    @Override
    public ContentValues toContentValues(Advertisement item) {
        ContentValues contentValues = new ContentValues();

        contentValues.put(AdvertisementColumns.COLUMN_IDENTIFIER, item.identifier);
        contentValues.put(AdvertisementColumns.COLUMN_AD_TYPE, item.getAdType());
        contentValues.put(AdvertisementColumns.COLUMN_EXPIRE_TIME, item.expireTime);
        contentValues.put(AdvertisementColumns.COLUMN_DELAY, item.delay);
        contentValues.put(AdvertisementColumns.COLUMN_SHOW_CLOSE_DELAY, item.showCloseDelay);
        contentValues.put(AdvertisementColumns.COLUMN_SHOW_CLOSE_INCENTIVISED, item.showCloseIncentivized);
        contentValues.put(AdvertisementColumns.COLUMN_COUNTDOWN, item.countdown);
        contentValues.put(AdvertisementColumns.COLUMN_VIDEO_WIDTH, item.videoWidth);
        contentValues.put(AdvertisementColumns.COLUMN_VIDEO_HEIGHT, item.videoHeight);
        contentValues.put(AdvertisementColumns.COLUMN_CTA_OVERLAY_ENABLED, item.ctaOverlayEnabled);
        contentValues.put(AdvertisementColumns.COLUMN_CTA_CLICK_AREA, item.ctaClickArea);
        contentValues.put(AdvertisementColumns.COLUMN_RETRY_COUNT, item.retryCount);
        contentValues.put(AdvertisementColumns.COLUMN_ENABLE_MOAT, item.enableMoat);
        contentValues.put(AdvertisementColumns.COLUMN_REQUIRES_NON_MARKET_INSTALL, item.requiresNonMarketInstall);
        contentValues.put(AdvertisementColumns.COLUMN_APP_ID, item.appID);
        contentValues.put(AdvertisementColumns.COLUMN_CAMPAIGN, item.campaign);
        contentValues.put(AdvertisementColumns.COLUMN_VIDEO_URL, item.videoUrl);
        contentValues.put(AdvertisementColumns.COLUMN_MD5, item.md5);
        contentValues.put(AdvertisementColumns.COLUMN_POSTROLL_BUNDLE_URL, item.postrollBundleUrl);
        contentValues.put(AdvertisementColumns.COLUMN_CTA_DESTINATION_URL, item.ctaDestinationUrl);
        contentValues.put(AdvertisementColumns.COLUMN_CTA_URL, item.ctaUrl);
        contentValues.put(AdvertisementColumns.COLUMN_AD_TOKEN, item.adToken);
        contentValues.put(AdvertisementColumns.COLUMN_VIDEO_IDENTIFIER, item.videoIdentifier);
        contentValues.put(AdvertisementColumns.COLUMN_TEMPLATE_URL, item.templateUrl);
        contentValues.put(AdvertisementColumns.COLUMN_TEMPLATE_ID, item.templateId);
        contentValues.put(AdvertisementColumns.COLUMN_TEMPLATE_TYPE, item.templateType);
        contentValues.put(AdvertisementColumns.COLUMN_MOAT_EXTRA_VAST, item.moatExtraVast);
        contentValues.put(AdvertisementColumns.COLUMN_AD_MARKET_ID, item.adMarketId);
        contentValues.put(AdvertisementColumns.COLUMN_BID_TOKEN, item.bidToken);
        contentValues.put(AdvertisementColumns.COLUMN_STATE, item.state);
        contentValues.put(AdvertisementColumns.COLUMN_PLACEMENT_ID, item.placementId);
        contentValues.put(AdvertisementColumns.COLUMN_AD_CONFIG, gson.toJson(item.adConfig));
        contentValues.put(AdvertisementColumns.COLUMN_MUTE_URLS, gson.toJson(item.muteUrls, stringArrayType));
        contentValues.put(AdvertisementColumns.COLUMN_UNMUTE_URLS, gson.toJson(item.unmuteUrls, stringArrayType));
        contentValues.put(AdvertisementColumns.COLUMN_CLOSE_URLS, gson.toJson(item.closeUrls, stringArrayType));
        contentValues.put(AdvertisementColumns.COLUMN_POSTROLL_CLICK_URLS, gson.toJson(item.postRollClickUrls, stringArrayType));
        contentValues.put(AdvertisementColumns.COLUMN_POSTROLL_VIEW_URLS, gson.toJson(item.postRollViewUrls, stringArrayType));
        contentValues.put(AdvertisementColumns.COLUMN_CLICK_URLS, gson.toJson(item.clickUrls, stringArrayType));
        contentValues.put(AdvertisementColumns.COLUMN_VIDEO_CLICK_URLS, gson.toJson(item.videoClickUrls, stringArrayType));
        contentValues.put(AdvertisementColumns.COLUMN_CHEKPOINTS, gson.toJson(item.checkpoints, checkpointListType));
        contentValues.put(AdvertisementColumns.COLUMN_TEMPLATE_SETTINGS, gson.toJson(item.templateSettings, stringMapType));
        contentValues.put(AdvertisementColumns.COLUMN_MRAID_FILES, gson.toJson(item.mraidFiles, stringMapType));
        contentValues.put(AdvertisementColumns.COLUMN_CACHEABLE_ASSETS, gson.toJson(item.cacheableAssets, cacheableMapType));
        contentValues.put(AdvertisementColumns.COLUMN_TT_DOWNLOAD, item.ttDownload);
        contentValues.put(AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_TIMESTAMP, item.assetDownloadStartTime);
        contentValues.put(AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_DURATION, item.assetDownloadDuration);
        contentValues.put(AdvertisementColumns.COLUMN_AD_REQUEST_START_TIMESTAMP, item.adRequestStartTime);
        return contentValues;
    }

    @NonNull
    @Override
    public Advertisement fromContentValues(ContentValues values) {
        Advertisement item = new Advertisement();

        item.identifier = values.getAsString(AdvertisementColumns.COLUMN_IDENTIFIER);
        item.adType = values.getAsInteger(AdvertisementColumns.COLUMN_AD_TYPE);
        item.expireTime = values.getAsLong(AdvertisementColumns.COLUMN_EXPIRE_TIME);
        item.delay = values.getAsInteger(AdvertisementColumns.COLUMN_DELAY);
        item.showCloseDelay = values.getAsInteger(AdvertisementColumns.COLUMN_SHOW_CLOSE_DELAY);
        item.showCloseIncentivized = values.getAsInteger(AdvertisementColumns.COLUMN_SHOW_CLOSE_INCENTIVISED);
        item.countdown = values.getAsInteger(AdvertisementColumns.COLUMN_COUNTDOWN);
        item.videoWidth = values.getAsInteger(AdvertisementColumns.COLUMN_VIDEO_WIDTH);
        item.videoHeight = values.getAsInteger(AdvertisementColumns.COLUMN_VIDEO_HEIGHT);
        item.retryCount = values.getAsInteger(AdvertisementColumns.COLUMN_RETRY_COUNT);
        item.requiresNonMarketInstall = getBoolean(values, AdvertisementColumns.COLUMN_REQUIRES_NON_MARKET_INSTALL);
        item.appID = values.getAsString(AdvertisementColumns.COLUMN_APP_ID);
        item.campaign = values.getAsString(AdvertisementColumns.COLUMN_CAMPAIGN);
        item.videoUrl = values.getAsString(AdvertisementColumns.COLUMN_VIDEO_URL);
        item.md5 = values.getAsString(AdvertisementColumns.COLUMN_MD5);
        item.postrollBundleUrl = values.getAsString(AdvertisementColumns.COLUMN_POSTROLL_BUNDLE_URL);
        item.ctaDestinationUrl = values.getAsString(AdvertisementColumns.COLUMN_CTA_DESTINATION_URL);
        item.ctaUrl = values.getAsString(AdvertisementColumns.COLUMN_CTA_URL);
        item.adToken = values.getAsString(AdvertisementColumns.COLUMN_AD_TOKEN);
        item.videoIdentifier = values.getAsString(AdvertisementColumns.COLUMN_VIDEO_IDENTIFIER);
        item.templateUrl = values.getAsString(AdvertisementColumns.COLUMN_TEMPLATE_URL);
        item.templateId = values.getAsString(AdvertisementColumns.COLUMN_TEMPLATE_ID);
        item.templateType = values.getAsString(AdvertisementColumns.COLUMN_TEMPLATE_TYPE);
        item.moatExtraVast = values.getAsString(AdvertisementColumns.COLUMN_MOAT_EXTRA_VAST);
        item.adMarketId = values.getAsString(AdvertisementColumns.COLUMN_AD_MARKET_ID);
        item.bidToken = values.getAsString(AdvertisementColumns.COLUMN_BID_TOKEN);
        item.state = values.getAsInteger(AdvertisementColumns.COLUMN_STATE);
        item.placementId = values.getAsString(AdvertisementColumns.COLUMN_PLACEMENT_ID);
        item.enableMoat = getBoolean(values, AdvertisementColumns.COLUMN_ENABLE_MOAT);
        item.ctaOverlayEnabled = getBoolean(values, AdvertisementColumns.COLUMN_CTA_OVERLAY_ENABLED);
        item.ctaClickArea = getBoolean(values, AdvertisementColumns.COLUMN_CTA_CLICK_AREA);
        item.adConfig = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_AD_CONFIG), AdConfig.class);
        item.muteUrls = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_MUTE_URLS), stringArrayType);
        item.unmuteUrls = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_UNMUTE_URLS), stringArrayType);
        item.closeUrls = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_CLOSE_URLS), stringArrayType);
        item.postRollClickUrls = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_POSTROLL_CLICK_URLS), stringArrayType);
        item.postRollViewUrls = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_POSTROLL_VIEW_URLS), stringArrayType);
        item.clickUrls = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_CLICK_URLS), stringArrayType);
        item.videoClickUrls = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_VIDEO_CLICK_URLS), stringArrayType);
        item.checkpoints = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_CHEKPOINTS), checkpointListType);
        item.templateSettings = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_TEMPLATE_SETTINGS), stringMapType);
        item.mraidFiles = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_MRAID_FILES), stringMapType);
        item.cacheableAssets = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_CACHEABLE_ASSETS), cacheableMapType);
        item.ttDownload = values.getAsLong(AdvertisementColumns.COLUMN_TT_DOWNLOAD);
        item.assetDownloadStartTime = values.getAsLong(AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_TIMESTAMP);
        item.assetDownloadDuration = values.getAsLong(AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_DURATION);
        item.adRequestStartTime = values.getAsLong(AdvertisementColumns.COLUMN_AD_REQUEST_START_TIMESTAMP);

        return item;
    }

    @Override
    public String tableName() {
        return AdvertisementColumns.TABLE_NAME;
    }

    public interface AdvertisementColumns extends IdColumns {
        String TABLE_NAME = "advertisement";
        String COLUMN_AD_TYPE = "ad_type";
        String COLUMN_APP_ID = "app_id";
        String COLUMN_EXPIRE_TIME = "expire_time";
        String COLUMN_CHEKPOINTS = "checkpoints";
        String COLUMN_MUTE_URLS = "mute_urls";
        String COLUMN_UNMUTE_URLS = "unmute_urls";
        String COLUMN_CLOSE_URLS = "close_urls";
        String COLUMN_POSTROLL_CLICK_URLS = "postroll_click_urls";
        String COLUMN_POSTROLL_VIEW_URLS = "postroll_view_urls";
        String COLUMN_CLICK_URLS = "click_urls";
        String COLUMN_VIDEO_CLICK_URLS = "video_click_urls";
        String COLUMN_DELAY = "delay";
        String COLUMN_CAMPAIGN = "campaign";
        String COLUMN_SHOW_CLOSE_DELAY = "show_close_delay";
        String COLUMN_SHOW_CLOSE_INCENTIVISED = "show_close_incentivized";
        String COLUMN_COUNTDOWN = "countdown";
        String COLUMN_VIDEO_URL = "video_url";
        String COLUMN_VIDEO_WIDTH = "video_width";
        String COLUMN_VIDEO_HEIGHT = "video_height";
        String COLUMN_MD5 = "md5";
        String COLUMN_POSTROLL_BUNDLE_URL = "postroll_bundle_url";
        String COLUMN_CTA_OVERLAY_ENABLED = "cta_overlay_enabled";
        String COLUMN_CTA_CLICK_AREA = "cta_click_area";
        String COLUMN_CTA_DESTINATION_URL = "cta_destination_url";
        String COLUMN_CTA_URL = "cta_url";
        String COLUMN_AD_CONFIG = "ad_config";
        String COLUMN_RETRY_COUNT = "retry_count";
        String COLUMN_AD_TOKEN = "ad_token";
        String COLUMN_VIDEO_IDENTIFIER = "video_identifier";
        String COLUMN_TEMPLATE_URL = "template_url";
        String COLUMN_TEMPLATE_SETTINGS = "template_settings";
        String COLUMN_MRAID_FILES = "mraid_files";
        String COLUMN_TEMPLATE_ID = "TEMPLATE_ID";
        String COLUMN_TEMPLATE_TYPE = "TEMPLATE_TYPE";
        String COLUMN_ENABLE_MOAT = "enable_moat";
        String COLUMN_MOAT_EXTRA_VAST = "moat_extra_vast";
        String COLUMN_REQUIRES_NON_MARKET_INSTALL = "requires_non_market_install";
        String COLUMN_AD_MARKET_ID = "ad_market_id";
        String COLUMN_BID_TOKEN = "bid_token";
        String COLUMN_PLACEMENT_ID = "placement_id";
        String COLUMN_STATE = "state";
        String COLUMN_CACHEABLE_ASSETS = "cacheable_assets";
        String COLUMN_TT_DOWNLOAD = "tt_download";
        String COLUMN_ASSET_DOWNLOAD_TIMESTAMP = "asset_download_timestamp";
        String COLUMN_ASSET_DOWNLOAD_DURATION = "asset_download_duration";
        String COLUMN_AD_REQUEST_START_TIMESTAMP = "ad_request_start_time";
    }

    public static final String CREATE_ADVERTISEMENT_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + AdvertisementDBAdapter.AdvertisementColumns.TABLE_NAME
            + "("
            + AdvertisementDBAdapter.AdvertisementColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT,  "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_IDENTIFIER + " TEXT UNIQUE, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_CONFIG + " TEXT,"//Json
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_TYPE + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_EXPIRE_TIME + " NUMERIC, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_DELAY + " NUMERIC, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_SHOW_CLOSE_DELAY + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_SHOW_CLOSE_INCENTIVISED + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_COUNTDOWN + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_VIDEO_HEIGHT + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_VIDEO_WIDTH + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CTA_OVERLAY_ENABLED + " SHORT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CTA_CLICK_AREA + " NUMERIC, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_RETRY_COUNT + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_ENABLE_MOAT + " SHORT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_REQUIRES_NON_MARKET_INSTALL + " SHORT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_APP_ID + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CAMPAIGN + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_VIDEO_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_MD5 + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_POSTROLL_BUNDLE_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CTA_DESTINATION_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CTA_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_TOKEN + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_VIDEO_IDENTIFIER + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_MUTE_URLS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_UNMUTE_URLS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CLOSE_URLS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_POSTROLL_CLICK_URLS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_POSTROLL_VIEW_URLS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CLICK_URLS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_VIDEO_CLICK_URLS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TEMPLATE_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TEMPLATE_ID + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TEMPLATE_TYPE + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_MOAT_EXTRA_VAST + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_MARKET_ID + " TEXT,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_BID_TOKEN + " TEXT,  "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CHEKPOINTS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TEMPLATE_SETTINGS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_MRAID_FILES + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CACHEABLE_ASSETS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_STATE + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_PLACEMENT_ID + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TT_DOWNLOAD + " NUMERIC,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_TIMESTAMP + " NUMERIC,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_DURATION + " NUMERIC,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_REQUEST_START_TIMESTAMP + " NUMERIC" +
            ")";
}
