package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;

import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

public class AdAssetDBAdapter implements DBAdapter<AdAsset> {

    @Override
    public ContentValues toContentValues(AdAsset item) {
        ContentValues contentValues = new ContentValues();

        contentValues.put(AdAssetColumns.COLUMN_IDENTIFIER, item.identifier);
        contentValues.put(AdAssetColumns.COLUMN_AD_ID, item.adIdentifier);
        contentValues.put(AdAssetColumns.COLUMN_PARENT_ID, item.parentId);

        contentValues.put(AdAssetColumns.COLUMN_SERVER_PATH, item.serverPath);
        contentValues.put(AdAssetColumns.COLUMN_LOCAL_PATH, item.localPath);

        contentValues.put(AdAssetColumns.COLUMN_FILE_STATUS, item.status);
        contentValues.put(AdAssetColumns.COLUMN_FILE_TYPE, item.fileType);
        contentValues.put(AdAssetColumns.COLUMN_FILE_SIZE, item.fileSize);
        contentValues.put(AdAssetColumns.COLUMN_RETRY_COUNT, item.retryCount);
        contentValues.put(AdAssetColumns.COLUMN_RETRY_ERROR, item.retryTypeError);

        return contentValues;
    }

    @NonNull
    @Override
    public AdAsset fromContentValues(ContentValues values) {
        AdAsset item = new AdAsset(
                values.getAsString(AdAssetColumns.COLUMN_AD_ID),
                values.getAsString(AdAssetColumns.COLUMN_SERVER_PATH),
                values.getAsString(AdAssetColumns.COLUMN_LOCAL_PATH),
                values.getAsString(AdAssetColumns.COLUMN_IDENTIFIER)
        );

        item.status = values.getAsInteger(AdAssetColumns.COLUMN_FILE_STATUS);
        item.fileType = values.getAsInteger(AdAssetColumns.COLUMN_FILE_TYPE);
        item.fileSize = values.getAsInteger(AdAssetColumns.COLUMN_FILE_SIZE);
        item.retryCount = values.getAsInteger(AdAssetColumns.COLUMN_RETRY_COUNT);
        item.retryTypeError = values.getAsInteger(AdAssetColumns.COLUMN_RETRY_ERROR);
        item.parentId = values.getAsString(AdAssetColumns.COLUMN_PARENT_ID);

        return item;
    }

    @Override
    public String tableName() {
        return AdAssetColumns.TABLE_NAME;
    }

    public interface AdAssetColumns extends IdColumns {
        String TABLE_NAME = "adAsset";

        String COLUMN_AD_ID = "ad_identifier";
        String COLUMN_PARENT_ID = "paren_id";
        String COLUMN_SERVER_PATH = "server_path";
        String COLUMN_LOCAL_PATH = "local_path";

        String COLUMN_FILE_STATUS = "file_status";
        String COLUMN_FILE_TYPE = "file_type";
        String COLUMN_FILE_SIZE = "file_size";
        String COLUMN_RETRY_COUNT = "retry_count";
        String COLUMN_RETRY_ERROR = "retry_error";
    }

    public static final String CREATE_ASSET_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + AdAssetColumns.TABLE_NAME
            + " ( "
            + AdAssetColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT, "

            + AdAssetColumns.COLUMN_IDENTIFIER + " TEXT UNIQUE, "
            + AdAssetColumns.COLUMN_PARENT_ID + " TEXT , "
            + AdAssetColumns.COLUMN_AD_ID + " TEXT NOT NULL, "

            + AdAssetColumns.COLUMN_SERVER_PATH + " TEXT, "
            + AdAssetColumns.COLUMN_LOCAL_PATH + " TEXT NOT NULL, "

            + AdAssetColumns.COLUMN_FILE_STATUS + " SHORT, "
            + AdAssetColumns.COLUMN_FILE_TYPE + " SHORT, "
            + AdAssetColumns.COLUMN_FILE_SIZE + " INT, "
            + AdAssetColumns.COLUMN_RETRY_COUNT + " SHORT, "
            + AdAssetColumns.COLUMN_RETRY_ERROR + " SHORT, "
            + "unique"
            + " ( "
            + AdAssetColumns.COLUMN_LOCAL_PATH + ", "
            + AdAssetColumns.COLUMN_AD_ID
            + " )" +
            ");";
}
