package com.vungle.warren.downloader;

import androidx.annotation.Nullable;
import android.text.TextUtils;

class RangeResponse {

    private static String TAG = RangeResponse.class.getName();

    @Nullable
    public final String dimension;
    public final long rangeStart;
    public final long rangeEnd;
    public final long total;

    // <unit> <range-start>-<range-end>/<size>
    // <unit> <range-start>-<range-end>/*
    // <unit> */<size>
    public RangeResponse(String header) {
        long rangeEndParsed = -1;
        long rangeStartParsed = -1;
        long totalParsed = -1;
        String dimensionParsed = null;

        if (!TextUtils.isEmpty(header)) {

            String[] parts = header.trim().split("\\s+");

            if (parts.length >= 2) {

                if (parts.length > 0) {
                    dimensionParsed = parts[0];
                }

                if (parts.length > 1 && !TextUtils.isEmpty(parts[1])) {
                    String[] rangeSegments = parts[1].split("/");


                    if (rangeSegments.length == 2) {
                        if (!TextUtils.isEmpty(rangeSegments[0])) {
                            String[] ranges = rangeSegments[0].split("-");

                            if (ranges.length == 2 && !TextUtils.isEmpty(ranges[0]) && !TextUtils.isEmpty(ranges[1])) {
                                try {
                                    rangeStartParsed = Long.parseLong(ranges[0]);
                                } catch (Throwable ignored) {
                                }

                                try {
                                    rangeEndParsed = Long.parseLong(ranges[1]);
                                } catch (Throwable ignored) {
                                }

                            }
                        }

                        if (!TextUtils.isEmpty(rangeSegments[1])) {
                            try {
                                totalParsed = Long.parseLong(rangeSegments[1]);
                            } catch (Throwable ignored) {
                            }
                        }
                    }
                }
            }
        }
        rangeStart = rangeStartParsed;
        rangeEnd = rangeEndParsed;
        total = totalParsed;
        dimension = dimensionParsed;
    }

}
