package com.vungle.warren.downloader;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.io.File;
import java.io.IOException;
import java.util.List;

public interface DownloaderCache {

    void init();

    void startTracking(@NonNull File file);

    void stopTracking(@NonNull File file);

    void onCacheHit(@NonNull File file, long score);

    @NonNull List<File> purge();

    boolean deleteAndRemove(@NonNull File file);

    boolean deleteContents(@NonNull File file);

    @NonNull
    File getFile(@NonNull String url) throws IOException;

    @NonNull
    File getMetaFile(@NonNull File cacheFile);

    void clear();

    long getCacheUpdateTimestamp(@NonNull File file);

    void setCacheLastUpdateTimestamp(@NonNull File file, long timestamp);
}
