package com.vungle.warren.downloader;

import androidx.annotation.IntDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.io.File;

public interface AssetDownloadListener {

    void onError(@NonNull DownloadError error, @Nullable DownloadRequest downloadRequest);

    void onProgress(@NonNull Progress progress, @NonNull DownloadRequest downloadRequest);

    void onSuccess(@NonNull File file, @NonNull DownloadRequest downloadRequest);

    class DownloadError {

        @ErrorReason
        public final int reason;
        public final int serverCode;
        public final Throwable cause;

        public DownloadError(int serverCode, Throwable th, int reason) {
            this.serverCode = serverCode;
            this.cause = th;
            this.reason = reason;
        }

        @IntDef(value = {ErrorReason.CONNECTION_ERROR, ErrorReason.REQUEST_ERROR, ErrorReason.DISK_ERROR,
                ErrorReason.FILE_NOT_FOUND_ERROR, ErrorReason.INTERNAL_ERROR})
        public @interface ErrorReason {
            int CONNECTION_ERROR = 0;
            int REQUEST_ERROR = 1;
            int DISK_ERROR = 2;
            int FILE_NOT_FOUND_ERROR = 3;
            int INTERNAL_ERROR = 4;
        }

    }

    class Progress {

        @ProgressStatus
        public int status;
        public int progressPercent;
        public long timestampDownloadStart;
        public long startBytes;
        public long sizeBytes;

        public static Progress copy(Progress progress) {
            Progress copy = new Progress();
            copy.status = progress.status;
            copy.progressPercent = progress.progressPercent;
            copy.timestampDownloadStart = progress.timestampDownloadStart;
            copy.sizeBytes = progress.sizeBytes;
            copy.startBytes = progress.startBytes;

            return copy;
        }

        @IntDef(flag = true, value = {Progress.ProgressStatus.STARTED, Progress.ProgressStatus.IN_PROGRESS, Progress.ProgressStatus.PAUSED,
                Progress.ProgressStatus.CANCELLED, Progress.ProgressStatus.DONE, Progress.ProgressStatus.LOST_CONNECTION, Progress.ProgressStatus.STATE_CHANGED})
        public @interface ProgressStatus {
            int STARTED = 0;
            int IN_PROGRESS = 1;
            int PAUSED = 2;
            int CANCELLED = 3;
            int DONE = 4;
            int LOST_CONNECTION = 5;
            int STATE_CHANGED = 6;
        }
    }


}
