package com.vungle.warren.analytics;

import androidx.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

import com.google.gson.JsonObject;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.Callback;
import com.vungle.warren.network.Response;

import java.net.MalformedURLException;
import java.util.ArrayList;

import static com.vungle.warren.VungleApiClient.ClearTextTrafficException;

public class VungleAnalytics implements AdAnalytics {

    private static final String TAG = VungleAnalytics.class.getSimpleName();

    private final VungleApiClient client;

    public VungleAnalytics(VungleApiClient client) {
        this.client = client;
    }

    @Override
    public String[] ping(@NonNull String[] urls) {
        if (urls.length == 0) return urls;

        ArrayList<String> failed = new ArrayList<>();
        for (String url : urls) {
            if (!TextUtils.isEmpty(url)) {
                try {
                    if (!client.pingTPAT(url)) {
                        failed.add(url);
                    }
                } catch (ClearTextTrafficException e) {
                    Log.e(TAG, "Cleartext Network Traffic is Blocked : " + url);
                } catch (MalformedURLException e) {
                    Log.e(TAG, "Invalid Url : " + url);
                }
            }
        }
        return failed.toArray(new String[0]);
    }

    @Override
    public void ri(JsonObject object) {
        if (object == null) return;

        client.ri(object).enqueue(new Callback<JsonObject>() {

            @Override
            public void onResponse(@NonNull Call<JsonObject> call, Response<JsonObject> response) {
                Log.d(TAG, "send RI success");
            }

            @Override
            public void onFailure(Call<JsonObject> call, Throwable t) {
                Log.d(TAG, "send RI Failure");
            }
        });
    }

}
