package com.vungle.warren;


import android.view.View;

public interface VungleNativeAd {
    /**
     * Returns a child view that will render the Ad,
     * this will have to be explicitly added to its parent View container
     *
     * It will expand to fit the parent container. Only request this
     * view when Vungle is initialized, it will return null otherwise.
     *
     * When used in an recyclerview, use the onViewAttachedToWindow to call {@link VungleNativeAd#setAdVisibility(boolean)}
     * that will allow paused video ads to resume playing.
     *
     * @return
     */
    View renderNativeView();

    /**
     * Call this method to clean up a nativeflexview and stop playing an ad
     */
    void finishDisplayingAd();

    /**
     * Call to handle Activity and RecyclerView attached or detached state,
     * this will ensure proper video states of pause/resume on scrolling beyond visible surface
     */
    void setAdVisibility(boolean isVisible);
}
