package com.vungle.warren;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.Pair;

import com.vungle.warren.error.VungleException;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.OrientationDelegate;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.WebAdContract;
import com.vungle.warren.ui.state.OptionsState;
import com.vungle.warren.ui.view.FullAdWidget;
import com.vungle.warren.ui.view.VungleWebClient;

public interface PresentationFactory {

    void getFullScreenPresentation(@NonNull Context context,
                                   @NonNull String placementId,
                                   @NonNull FullAdWidget fullAdWidget,
                                   @Nullable OptionsState optionsState,
                                   @NonNull final CloseDelegate closeDelegate,
                                   @NonNull final OrientationDelegate orientationDelegate,
                                   @Nullable Bundle savedState,
                                   @NonNull FullScreenCallback fullscreenCallback);

    void getNativeViewPresentation(@NonNull String placementId,
                                   @Nullable AdConfig adConfig,
                                   @NonNull CloseDelegate closeDelegate,
                                   @NonNull ViewCallback viewCallback);

    void saveState(Bundle bundle);

    void destroy();

    interface FullScreenCallback {
        void onResult(@Nullable Pair<AdContract.AdView, AdContract.AdvertisementPresenter> result, @Nullable VungleException error);
    }

    interface ViewCallback {
        void onResult(@Nullable Pair<WebAdContract.WebAdPresenter, VungleWebClient> result, @Nullable VungleException  error);
    }
}
