package com.vungle.warren;

import android.util.Log;

public class Plugin {

    private static final String TAG = Plugin.class.getSimpleName();

    /**
     * Override the info passed from Vungle's Plugins and Adapters
     * This should NOT be used by any Publishers
     * This should be called before calling Vungle.init()
     */
    public static void addWrapperInfo(VungleApiClient.WrapperFramework wrapperFramework, String wrapperFrameworkVersion) {
        if (wrapperFramework != null && wrapperFramework != VungleApiClient.WrapperFramework.none) {
            VungleApiClient.WRAPPER_FRAMEWORK_SELECTED = wrapperFramework;
            VungleApiClient.HEADER_UA += ";" + wrapperFramework;
            if (wrapperFrameworkVersion != null && !wrapperFrameworkVersion.isEmpty()) {
                VungleApiClient.HEADER_UA += "/" + wrapperFrameworkVersion;
            } else {
                Log.e(TAG, "Wrapper framework version is empty");
            }
        } else {
            Log.e(TAG, "Wrapper is null or is not none");
        }

        if (Vungle.isInitialized()) {
            Log.w(TAG, "VUNGLE WARNING: SDK already initialized, wou should set wrapper info before");
        }
    }
}
