package com.vungle.warren;

import com.vungle.warren.error.VungleException;

import java.util.concurrent.ExecutorService;

class PlayAdCallbackWrapper implements PlayAdCallback {

    private final PlayAdCallback playAdCallback;
    private final ExecutorService executorService;

    public PlayAdCallbackWrapper(ExecutorService executorService, PlayAdCallback playAdCallback) {
        this.playAdCallback = playAdCallback;
        this.executorService = executorService;
    }

    @Override
    public void onAdStart(final String id) {
        if (playAdCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdStart(id);
            }
        });
    }

    @Override
    public void onAdEnd(final String id, final boolean completed, final boolean isCTAClicked) {
        if (playAdCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdEnd(id, completed, isCTAClicked);
            }
        });
    }

    @Override
    public void onAdEnd(final String id) {
        if (playAdCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdEnd(id);
            }
        });
    }

    @Override
    public void onAdClick(final String id) {
        if (playAdCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdClick(id);
            }
        });
    }

    @Override
    public void onAdLeftApplication(final String id) {
        if (playAdCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdLeftApplication(id);
            }
        });
    }

    @Override
    public void onAdRewarded(final String id) {
        if (playAdCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdRewarded(id);
            }
        });
    }

    @Override
    public void onError(final String id, final VungleException exception) {
        if (playAdCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onError(id, exception);
            }
        });
    }
}
