package com.vungle.warren;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;

import com.vungle.warren.utility.NetworkProvider;

public class NetworkProviderReceiver extends BroadcastReceiver {
    private static final String TAG = NetworkProviderReceiver.class.getSimpleName();

    @Override
    public void onReceive(Context context, Intent intent) {
        if (context != null && ConnectivityManager.CONNECTIVITY_ACTION.equals(intent.getAction())) {
            NetworkProvider.getInstance(context).onNetworkChanged();
        }
    }

    public static void enableBroadcastReceiver(Context context, boolean state) {
        PackageManager pm = context.getPackageManager();
        ComponentName componentName = new ComponentName(context, NetworkProviderReceiver.class);
        if (hasReceiver(context)) {
            pm.setComponentEnabledSetting(componentName,
                    state ? PackageManager.COMPONENT_ENABLED_STATE_ENABLED : PackageManager.COMPONENT_ENABLED_STATE_DISABLED,
                    PackageManager.DONT_KILL_APP);
        }
    }

    public static boolean isEnabledBroadcastReceiver(Context context) {
        PackageManager pm = context.getPackageManager();
        ComponentName componentName = new ComponentName(context, NetworkProviderReceiver.class);
        return hasReceiver(context) && (pm.getComponentEnabledSetting(componentName) == PackageManager.COMPONENT_ENABLED_STATE_ENABLED);
    }

    public static boolean hasReceiver(Context context) {
        ComponentName componentName = new ComponentName(context, NetworkProviderReceiver.class);
        PackageManager pm = context.getPackageManager();
        try {
            ActivityInfo activityInfo = pm.getReceiverInfo(componentName, PackageManager.GET_META_DATA | PackageManager.GET_DISABLED_COMPONENTS);
            return activityInfo != null;
        } catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}