package com.vungle.warren;

import com.vungle.warren.error.VungleException;

import java.util.concurrent.ExecutorService;

class InitCallbackWrapper implements InitCallback {

    private final InitCallback callback;
    private final ExecutorService executorService;

    InitCallbackWrapper(ExecutorService executorService, InitCallback callback) {
        this.callback = callback;
        this.executorService = executorService;
    }

    @Override
    public void onSuccess() {
        if (callback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                callback.onSuccess();
            }
        });
    }

    @Override
    public void onError(final VungleException exception) {
        if (callback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                callback.onError(exception);
            }
        });
    }

    @Override
    public void onAutoCacheAdAvailable(final String placementId) {
        if (callback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                callback.onAutoCacheAdAvailable(placementId);
            }
        });
    }
}
