package com.vungle.warren;

/**
 * This interface allow SDK to participate in Header bidding. This callback interface is supposed
 * to register by using {@link Vungle#setHeaderBiddingCallback(HeaderBiddingCallback)} method.
 */
public interface HeaderBiddingCallback {

    /**
     * Callback method to notify availability of bid token for a placement.
     *
     * @param placementId Placement identifier for bid token
     * @param bidToken    Bid token.
     */
    void onBidTokenAvailable(String placementId, String bidToken);

    /**Callback method to notify that ad is ready or available for given placement. T
     * @param placementId Placement id of requested ad.
     * @param bidToken
     */
    void adAvailableForBidToken(String placementId, String bidToken);
}
