package com.vungle.warren;

import androidx.annotation.NonNull;

import com.vungle.warren.persistence.CacheManager;

public class DownloaderSizeProvider implements SizeProvider {

    private final float cap;
    private CacheManager cacheManager;
    private RuntimeValues runtimeValues;

    public DownloaderSizeProvider(@NonNull CacheManager cacheManager, @NonNull RuntimeValues runtimeValues, float cap) {
        this.cacheManager = cacheManager;
        this.runtimeValues = runtimeValues;
        this.cap = cap;
    }

    @Override
    public long getTargetSize() {
        VungleSettings settings = runtimeValues.settings.get();
        if (settings == null)
            return 0;

        long available = cacheManager.getBytesAvailable() / 2;
        long max = settings.getMaximumStorageForCleverCache();
        long toFree = Math.max(0, settings.getMinimumSpaceForAd() - available);
        long size = Math.min(max, available);
        size -= size * cap;
        size -= toFree;
        return Math.max(0, size);
    }

}
