package com.vungle.warren;

import androidx.annotation.NonNull;

import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;

import java.util.concurrent.ExecutorService;

class DownloadCallbackWrapper implements AdLoader.DownloadCallback {

    private final AdLoader.DownloadCallback downloadCallback;
    private final ExecutorService executorService;

    public DownloadCallbackWrapper(ExecutorService executorService, AdLoader.DownloadCallback downloadCallback) {
        this.downloadCallback = downloadCallback;
        this.executorService = executorService;
    }

    @Override
    public void onDownloadCompleted(@NonNull final String placementId, @NonNull final String advertisementId) {
        if (downloadCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                downloadCallback.onDownloadCompleted(placementId, advertisementId);
            }
        });
    }

    @Override
    public void onDownloadFailed(@NonNull final VungleException exception, final String placementId, final String advertisementId) {
        if (downloadCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                downloadCallback.onDownloadFailed(exception, placementId, advertisementId);
            }
        });
    }

    @Override
    public void onReady(@NonNull final String id, @NonNull final Placement placement, @NonNull final Advertisement advertisement) {
        if (downloadCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                downloadCallback.onReady(id, placement, advertisement);
            }
        });
    }
}
