/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.text.TextUtils;
import android.util.Log;
import com.vungle.warren.utility.FileUtility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class UnzipUtility {
    private static final int BUFFER_SIZE = 4096;
    private static final String TAG = UnzipUtility.class.getCanonicalName();

    public static List<File> unzip(String zipFilePath, String destDirectory) throws IOException {
        return UnzipUtility.unzip(zipFilePath, destDirectory, null);
    }

    public static List<File> unzip(String zipFilePath, String destDirectory, Filter filter) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        UnzipUtility.validateZip(zipFilePath);
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        ArrayList<File> extractedFiles = new ArrayList<File>();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (filter == null || filter.matches(filePath)) {
                UnzipUtility.validateFilename(filePath, destDirectory);
                if (entry.isDirectory()) {
                    File dir = new File(filePath);
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                } else {
                    UnzipUtility.extractFile(zipIn, filePath);
                    extractedFiles.add(new File(filePath));
                }
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
        return extractedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateZip(String zipFilePath) throws IOException {
        ZipFile zipfile = null;
        if (TextUtils.isEmpty((CharSequence)zipFilePath)) {
            throw new IOException("Path is empty");
        }
        File src = new File(zipFilePath);
        if (!src.exists()) {
            throw new IOException("File does not exist");
        }
        try {
            zipfile = new ZipFile(new File(zipFilePath));
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        File dest = new File(filePath);
        if (dest.exists()) {
            dest.delete();
        }
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            bos = new BufferedOutputStream(fos);
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
        catch (FileNotFoundException fnf) {
            block7: {
                try {
                    if (dest.getParentFile().exists()) break block7;
                    File folder = dest.getParentFile();
                    while (!folder.mkdir()) {
                        folder = folder.getParentFile();
                    }
                    UnzipUtility.extractFile(zipIn, filePath);
                }
                catch (Throwable throwable) {
                    FileUtility.closeQuietly(bos);
                    FileUtility.closeQuietly(fos);
                    throw throwable;
                }
            }
            FileUtility.closeQuietly(bos);
            FileUtility.closeQuietly(fos);
        }
        FileUtility.closeQuietly(bos);
        FileUtility.closeQuietly(fos);
    }

    private static String validateFilename(String filename, String intendedDir) throws IOException {
        File iD;
        String canonicalID;
        File f = new File(filename);
        String canonicalPath = f.getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return canonicalPath;
        }
        String msg = "File is outside extraction target directory.";
        Log.e((String)TAG, (String)"File is outside extraction target directory.");
        throw new ZipSecurityException("File is outside extraction target directory.");
    }

    public static interface Filter {
        public boolean matches(String var1);
    }

    static class ZipSecurityException
    extends IOException {
        ZipSecurityException(String message) {
            super(message);
        }
    }
}

