/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;

public class RefreshHandler
extends Handler {
    private static final String TAG = RefreshHandler.class.getSimpleName();
    private static final int ID = 0;
    private static final int DISABLE_REFRESH_VALUE = 0;
    private long handlerStartTime;
    private long handlerTimeElapsed;
    private final long refreshDuration;
    private Runnable runnable;

    public RefreshHandler(@NonNull Runnable runnable, long refreshInterval) {
        this.refreshDuration = refreshInterval;
        this.runnable = runnable;
    }

    public void pause() {
        if (this.hasMessages(0)) {
            this.handlerTimeElapsed = System.currentTimeMillis() - this.handlerStartTime;
            Log.d((String)TAG, (String)("Pausing Refresh Handler. Millis Elapsed :" + this.handlerTimeElapsed));
            this.clean();
            this.handlerStartTime = 0L;
        }
    }

    public void start() {
        if (this.refreshDuration == 0L) {
            return;
        }
        if (this.handlerTimeElapsed != 0L) {
            Log.d((String)TAG, (String)("Resuming Refresh Handler. Millis To Go : " + (this.refreshDuration - this.handlerTimeElapsed)));
            this.clean();
            this.postDelayed(this.runnable, this.refreshDuration - this.handlerTimeElapsed);
            this.handlerTimeElapsed = 0L;
        } else {
            this.removeCallbacks(this.runnable);
            this.postDelayed(this.runnable, this.refreshDuration);
            Log.d((String)TAG, (String)"Starting Refresh Handler");
        }
        this.handlerStartTime = System.currentTimeMillis();
    }

    public void clean() {
        this.removeMessages(0);
        this.removeCallbacks(this.runnable);
    }
}

