/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class FileUtility {
    private static final String TAG = FileUtility.class.getSimpleName();

    public static void printDirectoryTree(File folder) {
    }

    private static void printDirectoryTree(File folder, int indent, StringBuilder sb) {
        if (folder == null) {
            return;
        }
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("folder is not a Directory");
        }
        sb.append(FileUtility.getIndentString(indent)).append("+--").append(folder.getName()).append("/\n");
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                FileUtility.printDirectoryTree(file, indent + 1, sb);
                continue;
            }
            FileUtility.printFile(file, indent + 1, sb);
        }
    }

    private static void printFile(File file, int indent, StringBuilder sb) {
        sb.append(FileUtility.getIndentString(indent)).append("+--").append(file.getName()).append('\n');
    }

    private static String getIndentString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("|  ");
        }
        return sb.toString();
    }

    public static void delete(File f) throws IOException {
        if (f == null || !f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files == null) {
                return;
            }
            for (File c : files) {
                FileUtility.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static byte[] extractBytes(@Nullable File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        int size = (int)file.length();
        if (size > 0) {
            byte[] byArray;
            byte[] bytes = new byte[size];
            BufferedInputStream buffy = null;
            try {
                buffy = new BufferedInputStream(new FileInputStream(file));
                int readSize = buffy.read(bytes);
                if (readSize < size) {
                    throw new IOException("Failed to read all bytes in the file, object recreation will fail");
                }
                byArray = bytes;
            }
            catch (FileNotFoundException ex) {
                try {
                    Log.e((String)TAG, (String)"FileNotFoundException ", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    FileUtility.closeQuietly(buffy);
                    throw throwable;
                }
                FileUtility.closeQuietly(buffy);
            }
            FileUtility.closeQuietly(buffy);
            return byArray;
        }
        return new byte[0];
    }

    @NonNull
    public static HashMap<String, String> readMap(@NonNull String path) {
        File file = new File(path);
        Object ser = FileUtility.readSerializable(file);
        if (ser instanceof HashMap) {
            return (HashMap)ser;
        }
        return new HashMap<String, String>();
    }

    public static void writeMap(@NonNull String path, @NonNull HashMap<String, String> map) {
        File file = new File(path);
        if (map.isEmpty()) {
            return;
        }
        FileUtility.writeSerializable(file, map);
    }

    @NonNull
    public static ArrayList<String> readAllLines(@NonNull String path) {
        Object ser;
        File file = new File(path);
        if (file.exists() && (ser = FileUtility.readSerializable(file)) instanceof ArrayList) {
            return (ArrayList)ser;
        }
        return new ArrayList<String>();
    }

    public static void writeAllLines(@NonNull String path, @NonNull ArrayList<String> lines) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        if (lines.isEmpty()) {
            return;
        }
        FileUtility.writeSerializable(file, lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSerializable(@NonNull File file, @Nullable Serializable serializable) {
        if (file.exists()) {
            file.delete();
        }
        if (serializable == null) {
            return;
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(serializable);
        }
        catch (IOException e) {
            try {
                Log.e((String)TAG, (String)"IOIOException", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtility.closeQuietly(out);
                throw throwable;
            }
            FileUtility.closeQuietly(out);
        }
        FileUtility.closeQuietly(out);
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Nullable
    public static <T> T readSerializable(File file) {
        Object object;
        if (!file.exists()) {
            return null;
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(file));
            object = in.readObject();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOIOException", (Throwable)e);
            FileUtility.closeQuietly(in);
        }
        catch (ClassNotFoundException e2) {
            Log.e((String)TAG, (String)"ClassNotFoundException", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    FileUtility.closeQuietly(in);
                    throw throwable;
                }
            }
            FileUtility.closeQuietly(in);
        }
        FileUtility.closeQuietly(in);
        return (T)object;
        return null;
    }

    public static long size(@Nullable File file) {
        if (file == null || !file.exists()) {
            return 0L;
        }
        long length = 0L;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null && children.length > 0) {
                for (File child : children) {
                    length += FileUtility.size(child);
                }
            }
            return length;
        }
        return file.length();
    }
}

