/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.view;

import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import com.vungle.warren.ui.view.WebViewAPI;

public class VungleWebClient
extends WebViewClient
implements WebViewAPI {
    public static final String TAG = VungleWebClient.class.getSimpleName();
    private Advertisement advertisement;
    private Placement placement;
    private WebViewAPI.MRAIDDelegate MRAIDDelegate;
    private boolean collectConsent;
    private WebView loadedWebView;
    private boolean ready;
    private String gdprTitle;
    private String gdprBody;
    private String gdprAccept;
    private String gdprDeny;
    private Boolean isViewable;
    private WebViewAPI.WebClientErrorListener errorListener;

    public VungleWebClient(Advertisement advertisement, Placement placement) {
        this.advertisement = advertisement;
        this.placement = placement;
    }

    @Override
    public void setConsentStatus(boolean collectedConsent, @Nullable String title, @Nullable String message, @Nullable String accept, @Nullable String deny) {
        this.collectConsent = collectedConsent;
        this.gdprTitle = title;
        this.gdprBody = message;
        this.gdprAccept = accept;
        this.gdprDeny = deny;
    }

    @Override
    public void setMRAIDDelegate(WebViewAPI.MRAIDDelegate MRAIDDelegate2) {
        this.MRAIDDelegate = MRAIDDelegate2;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Log.d((String)TAG, (String)("MRAID Command " + url));
        if (TextUtils.isEmpty((CharSequence)url)) {
            Log.e((String)TAG, (String)"Invalid URL ");
            return false;
        }
        Uri uri = Uri.parse((String)url);
        if (uri.getScheme() != null && uri.getScheme().equals("mraid")) {
            String command = uri.getHost();
            if (command.equals("propertiesChangeCompleted") && !this.ready) {
                JsonObject mraidArgs = this.advertisement.createMRAIDArgs();
                view.loadUrl("javascript:window.vungle.mraidBridge.notifyReadyEvent(" + mraidArgs + ")");
                this.ready = true;
            } else if (this.MRAIDDelegate != null) {
                JsonObject args = new JsonObject();
                for (String param : uri.getQueryParameterNames()) {
                    args.addProperty(param, uri.getQueryParameter(param));
                }
                if (this.MRAIDDelegate.processCommand(command, args)) {
                    view.loadUrl("javascript:window.vungle.mraidBridge.notifyCommandComplete()");
                }
            }
            return true;
        }
        return false;
    }

    public void onPageFinished(WebView webView, String url) {
        super.onPageFinished(webView, url);
        switch (this.advertisement.getAdType()) {
            case 0: {
                String inject = "javascript:function actionClicked(action){Android.performAction(action);};";
                webView.loadUrl(inject);
                break;
            }
            case 1: {
                this.loadedWebView = webView;
                this.loadedWebView.setVisibility(0);
                this.notifyPropertiesChange(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Client Type!");
            }
        }
    }

    @Override
    public void notifyPropertiesChange(boolean skipCmdQueue) {
        if (this.loadedWebView != null) {
            JsonObject screenJson = new JsonObject();
            JsonObject size = new JsonObject();
            size.addProperty("width", (Number)this.loadedWebView.getWidth());
            size.addProperty("height", (Number)this.loadedWebView.getHeight());
            JsonObject position = new JsonObject();
            position.addProperty("x", (Number)0);
            position.addProperty("y", (Number)0);
            position.addProperty("width", (Number)this.loadedWebView.getWidth());
            position.addProperty("height", (Number)this.loadedWebView.getHeight());
            JsonObject supports = new JsonObject();
            supports.addProperty("sms", Boolean.valueOf(false));
            supports.addProperty("tel", Boolean.valueOf(false));
            supports.addProperty("calendar", Boolean.valueOf(false));
            supports.addProperty("storePicture", Boolean.valueOf(false));
            supports.addProperty("inlineVideo", Boolean.valueOf(false));
            screenJson.add("maxSize", (JsonElement)size);
            screenJson.add("screenSize", (JsonElement)size);
            screenJson.add("defaultPosition", (JsonElement)position);
            screenJson.add("currentPosition", (JsonElement)position);
            screenJson.add("supports", (JsonElement)supports);
            screenJson.addProperty("placementType", this.advertisement.getTemplateType());
            if (this.isViewable != null) {
                screenJson.addProperty("isViewable", this.isViewable);
            }
            screenJson.addProperty("os", "android");
            screenJson.addProperty("osVersion", Integer.toString(Build.VERSION.SDK_INT));
            screenJson.addProperty("incentivized", Boolean.valueOf(this.placement.isIncentivized()));
            screenJson.addProperty("enableBackImmediately", Boolean.valueOf(this.advertisement.getShowCloseDelay(this.placement.isIncentivized()) == 0));
            screenJson.addProperty("version", "1.0");
            if (this.collectConsent) {
                screenJson.addProperty("consentRequired", Boolean.valueOf(true));
                screenJson.addProperty("consentTitleText", this.gdprTitle);
                screenJson.addProperty("consentBodyText", this.gdprBody);
                screenJson.addProperty("consentAcceptButtonText", this.gdprAccept);
                screenJson.addProperty("consentDenyButtonText", this.gdprDeny);
            } else {
                screenJson.addProperty("consentRequired", Boolean.valueOf(false));
            }
            Log.d((String)TAG, (String)("loadJsjavascript:window.vungle.mraidBridge.notifyPropertiesChange(" + screenJson + "," + skipCmdQueue + ")"));
            this.loadedWebView.loadUrl("javascript:window.vungle.mraidBridge.notifyPropertiesChange(" + screenJson + "," + skipCmdQueue + ")");
        }
    }

    @Override
    public void setAdVisibility(boolean isViewable) {
        this.isViewable = isViewable;
        this.notifyPropertiesChange(false);
    }

    @Override
    public void setErrorListener(WebViewAPI.WebClientErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        if (Build.VERSION.SDK_INT < 23) {
            Log.e((String)TAG, (String)("Error desc " + description));
            Log.e((String)TAG, (String)("Error for URL " + failingUrl));
            String errorDesc = failingUrl + " " + description;
            if (this.errorListener != null) {
                this.errorListener.onReceivedError(errorDesc);
            }
        }
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        if (Build.VERSION.SDK_INT >= 23) {
            Log.e((String)TAG, (String)("Error desc " + error.getDescription().toString()));
            Log.e((String)TAG, (String)("Error for URL " + request.getUrl().toString()));
            String errorDesc = request.getUrl().toString() + " " + error.getDescription().toString();
            if (this.errorListener != null) {
                this.errorListener.onReceivedError(errorDesc);
            }
        }
    }
}

