/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.view;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextThemeWrapper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.OrientationDelegate;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.view.FullAdWidget;
import com.vungle.warren.utility.ExternalRouter;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BaseAdView<T extends AdContract.AdvertisementPresenter>
implements AdContract.AdView<T> {
    private final OrientationDelegate orientationDelegate;
    private final CloseDelegate closeDelegate;
    protected Handler handler = new Handler(Looper.getMainLooper());
    protected final String TAG = this.getClass().getSimpleName();
    protected final FullAdWidget view;
    protected final Context context;
    protected Dialog currentDialog;

    public BaseAdView(@NonNull Context context, @NonNull FullAdWidget view, @NonNull OrientationDelegate orientationDelegate, @NonNull CloseDelegate closeDelegate) {
        this.view = view;
        this.context = context;
        this.orientationDelegate = orientationDelegate;
        this.closeDelegate = closeDelegate;
    }

    @Override
    public void setOrientation(int orientation) {
        this.orientationDelegate.setOrientation(orientation);
    }

    @Override
    public String getWebsiteUrl() {
        return this.view.getUrl();
    }

    @Override
    public void close() {
        this.closeDelegate.close();
    }

    @Override
    public void destroyAdView() {
        this.view.release();
    }

    @Override
    public void showCloseButton() {
        this.view.showCloseButton(true);
    }

    @Override
    public void open(@NonNull String url) {
        Log.d((String)this.TAG, (String)("Opening " + url));
        if (!ExternalRouter.launch(url, this.context)) {
            Log.e((String)this.TAG, (String)("Cannot open url " + url));
        }
    }

    @Override
    public void showDialog(@Nullable String dialogTitle, @Nullable String dialogBody, @NonNull String dialogContinue, @NonNull String dialogClose, final @Nullable DialogInterface.OnClickListener responseListener) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)new ContextThemeWrapper(this.context, this.context.getApplicationInfo().theme));
        DialogInterface.OnDismissListener dismissListener = new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                BaseAdView.this.currentDialog = null;
            }
        };
        DialogInterface.OnClickListener onClickListenerProxy = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                BaseAdView.this.currentDialog = null;
                if (responseListener != null) {
                    responseListener.onClick(dialog, which);
                }
            }
        };
        DialogClickListenerProxy listener = new DialogClickListenerProxy(onClickListenerProxy, dismissListener);
        if (!TextUtils.isEmpty((CharSequence)dialogTitle)) {
            dialogBuilder.setTitle((CharSequence)dialogTitle);
        }
        if (!TextUtils.isEmpty((CharSequence)dialogBody)) {
            dialogBuilder.setMessage((CharSequence)dialogBody);
        }
        dialogBuilder.setPositiveButton((CharSequence)dialogContinue, (DialogInterface.OnClickListener)listener);
        dialogBuilder.setNegativeButton((CharSequence)dialogClose, (DialogInterface.OnClickListener)listener);
        dialogBuilder.setCancelable(false);
        this.currentDialog = dialogBuilder.create();
        listener.autoRelease(this.currentDialog);
        this.currentDialog.show();
    }

    @Override
    public void resumeWeb() {
        this.view.resumeWeb();
    }

    @Override
    public void pauseWeb() {
        this.view.pauseWeb();
    }

    @Override
    public void setImmersiveMode() {
        this.view.setImmersiveMode();
    }

    private static class DialogClickListenerProxy
    implements DialogInterface.OnClickListener,
    DialogInterface.OnDismissListener {
        private AtomicReference<DialogInterface.OnClickListener> ckickRef = new AtomicReference();
        private AtomicReference<DialogInterface.OnDismissListener> dismissRef = new AtomicReference();

        public DialogClickListenerProxy(DialogInterface.OnClickListener onClickListener, DialogInterface.OnDismissListener onDismissListener) {
            this.ckickRef.set(onClickListener);
            this.dismissRef.set(onDismissListener);
        }

        public void onClick(DialogInterface dialog, int which) {
            dialog.dismiss();
            DialogInterface.OnClickListener base = this.ckickRef.get();
            if (base != null) {
                base.onClick(dialog, which);
            }
        }

        private void autoRelease(Dialog dialog) {
            dialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        }

        public void onDismiss(DialogInterface dialog) {
            DialogInterface.OnDismissListener base = this.dismissRef.get();
            if (base != null) {
                base.onDismiss(dialog);
            }
            this.dismissRef.set(null);
            this.ckickRef.set(null);
        }
    }
}

