/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.vungle.warren.AdLoader;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.tasks.Job;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;
import java.util.Collection;

public class DownloadJob
implements Job {
    static final String TAG = DownloadJob.class.getCanonicalName();
    private static final String PLACEMENT_KEY = "placement";
    private final AdLoader adLoader;
    private final VungleStaticApi vungleApi;

    public DownloadJob(@NonNull AdLoader adLoader, @NonNull VungleStaticApi vungleApi) {
        this.adLoader = adLoader;
        this.vungleApi = vungleApi;
    }

    public static JobInfo makeJobInfo(String placementID) {
        Bundle extras = new Bundle();
        extras.putString(PLACEMENT_KEY, placementID);
        String tag = TAG + " " + placementID;
        return new JobInfo(tag).setUpdateCurrent(true).setExtras(extras).setPriority(4);
    }

    @Override
    public int onRunJob(Bundle params, JobRunner jobRunner) {
        String placementID = params.getString(PLACEMENT_KEY, null);
        Collection<String> validPlacements = this.vungleApi.getValidPlacements();
        if (placementID == null || !validPlacements.contains(placementID)) {
            return 1;
        }
        this.adLoader.loadPendingInternal(placementID);
        return 0;
    }
}

