/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.persistence;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import com.vungle.warren.persistence.Query;

public class DatabaseHelper
extends SQLiteOpenHelper {
    public static final String DB_NAME = "vungle_db";
    private final DatabaseFactory databaseFactory;

    public DatabaseHelper(@NonNull Context context, int version, @NonNull DatabaseFactory databaseFactory) {
        super(context.getApplicationContext(), DB_NAME, null, version);
        this.databaseFactory = databaseFactory;
    }

    public synchronized void onCreate(SQLiteDatabase db) {
        this.databaseFactory.create(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.databaseFactory.onUpgrade(db, oldVersion, newVersion);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.databaseFactory.onDowngrade(db, oldVersion, newVersion);
    }

    public long insertWithConflict(String table, ContentValues values, int strategy) throws DBException {
        try {
            return this.loadWritableDB().insertWithOnConflict(table, null, values, strategy);
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
    }

    public long update(Query query, ContentValues values) throws DBException {
        try {
            return this.loadWritableDB().update(query.tableName, values, query.selection, query.args);
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
    }

    public Cursor query(Query query) {
        return this.loadWritableDB().query(query.tableName, query.columns, query.selection, query.args, query.groupBy, query.having, query.orderBy, query.limit);
    }

    public Cursor queryRaw(String sql, String[] selectionArgs) {
        return this.loadWritableDB().rawQuery(sql, selectionArgs);
    }

    public void delete(Query query) throws DBException {
        try {
            this.loadWritableDB().delete(query.tableName, query.selection, query.args);
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
    }

    public void execSQL(String s) throws DBException {
        try {
            this.loadWritableDB().execSQL(s);
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
    }

    public synchronized void dropDb() {
        this.databaseFactory.deleteData(this.loadWritableDB());
        this.close();
        this.onCreate(this.loadWritableDB());
    }

    public void init() {
        this.loadWritableDB();
    }

    private synchronized SQLiteDatabase loadWritableDB() {
        return this.getWritableDatabase();
    }

    public static interface DatabaseFactory {
        public void onUpgrade(SQLiteDatabase var1, int var2, int var3);

        public void create(SQLiteDatabase var1);

        public void deleteData(SQLiteDatabase var1);

        public void onDowngrade(SQLiteDatabase var1, int var2, int var3);
    }

    public static class DBException
    extends Exception {
        public DBException(String message) {
            super(message);
        }
    }
}

