/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Environment;
import android.os.FileObserver;
import android.os.StatFs;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.PermissionChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CacheManager {
    private static final String COM_VUNGLE_SDK = "com.vungle.sdk";
    private static final String PATH_ID = "cache_path";
    private static final String PATH_IDS = "cache_paths";
    private static final String VUNGLE_DIR = "vungle_cache";
    private final Context context;
    private final SharedPreferences prefs;
    private Set<Listener> listeners = new HashSet<Listener>();
    private File current;
    private List<File> old = new ArrayList<File>();
    private boolean changed;
    private List<FileObserver> observers = new ArrayList<FileObserver>();

    public CacheManager(@NonNull Context context) {
        this.context = context;
        this.prefs = context.getSharedPreferences(COM_VUNGLE_SDK, 0);
    }

    private synchronized void selectFileDest() {
        if (this.current == null) {
            String path = this.prefs.getString(PATH_ID, null);
            this.current = path != null ? new File(path) : null;
        }
        File external = this.context.getExternalFilesDir(null);
        File internal = this.context.getFilesDir();
        boolean canUseExternal = (Build.VERSION.SDK_INT >= 19 || PermissionChecker.checkCallingOrSelfPermission((Context)this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) && Environment.getExternalStorageState().equals("mounted") && external != null;
        File result = null;
        boolean created = false;
        for (File dir : Arrays.asList(new File(canUseExternal ? external : internal, VUNGLE_DIR), new File(internal, VUNGLE_DIR))) {
            boolean success;
            if (dir.exists() && dir.isFile() && !dir.delete()) break;
            if (dir.exists()) {
                success = dir.isDirectory() && dir.canWrite();
            } else {
                created = success = dir.mkdirs();
            }
            if (!success) continue;
            result = dir;
            break;
        }
        File obsoleted = this.context.getCacheDir();
        Set known = this.prefs.getStringSet(PATH_IDS, new HashSet());
        if (result != null) {
            known.add(result.getPath());
        }
        known.add(obsoleted.getPath());
        this.prefs.edit().putStringSet(PATH_IDS, known).apply();
        this.old.clear();
        for (String path : known) {
            if (result != null && result.getPath().equals(path)) continue;
            this.old.add(new File(path));
        }
        if (created || result != null && !result.equals(this.current) || this.current != null && !this.current.equals(result)) {
            this.current = result;
            if (this.current != null) {
                this.prefs.edit().putString(PATH_ID, this.current.getPath()).apply();
            }
            for (Listener l : this.listeners) {
                l.onCacheChanged();
            }
            this.changed = true;
        }
        this.observeDirectory(external);
    }

    private void check() {
        if (!(this.current != null && this.current.exists() && this.current.isDirectory() && this.current.canWrite())) {
            this.selectFileDest();
        }
    }

    private synchronized void observeDirectory(File root) {
        if (root == null) {
            return;
        }
        this.observers.clear();
        this.observers.add(new FileObserver(root.getPath(), 1024){

            public void onEvent(int event, @Nullable String path) {
                this.stopWatching();
                CacheManager.this.selectFileDest();
            }
        });
        while (root.getParent() != null) {
            final String dirName = root.getName();
            this.observers.add(new FileObserver(root.getParent(), 256){

                public void onEvent(int event, @Nullable String path) {
                    if (dirName.equals(path)) {
                        this.stopWatching();
                        CacheManager.this.selectFileDest();
                    }
                }
            });
            root = root.getParentFile();
        }
        for (FileObserver observer : this.observers) {
            observer.startWatching();
        }
    }

    @Nullable
    public synchronized File getCache() {
        this.check();
        return this.current;
    }

    public synchronized List<File> getOldCaches() {
        this.check();
        return this.old;
    }

    public synchronized void addListener(Listener listener) {
        this.check();
        this.listeners.add(listener);
        if (this.changed) {
            listener.onCacheChanged();
        }
    }

    public synchronized void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public long getBytesAvailable() {
        File dir = this.getCache();
        long bytesAvailable = -1L;
        if (dir == null) {
            return bytesAvailable;
        }
        StatFs stats = new StatFs(dir.getPath());
        bytesAvailable = Build.VERSION.SDK_INT >= 18 ? stats.getBlockSizeLong() * stats.getAvailableBlocksLong() : (long)(stats.getBlockSize() * stats.getAvailableBlocks());
        return bytesAvailable;
    }

    public static interface Listener {
        public void onCacheChanged();
    }
}

